@extends('layouts.admin')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-xl font-semibold">Span Management</h1>
        <a href="{{ route('admin.spans.create') }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Span</a>
    </div>

    @if(session('success'))
        <div class="mb-4 p-3 bg-green-100 text-green-700 rounded">{{ session('success') }}</div>
    @endif

    <div class="bg-white rounded-lg shadow p-4 mb-4">
        <form method="GET" action="{{ route('admin.spans.index') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <input type="text" name="q" value="{{ $q }}" placeholder="Search name/code/category/owner" class="border rounded p-2" />
            <select name="status" class="border rounded p-2">
                <option value="">All Status</option>
                <option value="active" {{ $status==='active'?'selected':'' }}>Active</option>
                <option value="inactive" {{ $status==='inactive'?'selected':'' }}>Inactive</option>
                <option value="archived" {{ $status==='archived'?'selected':'' }}>Archived</option>
            </select>
            <button class="px-4 py-2 bg-indigo-600 text-white rounded">Filter</button>
            <a href="{{ route('admin.spans.index') }}" class="px-4 py-2 bg-gray-200 text-gray-800 rounded">Reset</a>
        </form>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
            <tr>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Name</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Code</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Category</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Owner</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Status</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Period</th>
                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500">Actions</th>
            </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
            @forelse($spans as $span)
                <tr>
                    <td class="px-4 py-2">{{ $span->name }}</td>
                    <td class="px-4 py-2">{{ $span->code }}</td>
                    <td class="px-4 py-2">{{ $span->category ?? '-' }}</td>
                    <td class="px-4 py-2">{{ $span->owner ?? '-' }}</td>
                    <td class="px-4 py-2">
                        <span class="px-2 py-1 rounded text-xs {{ $span->status==='active'?'bg-green-100 text-green-700':($span->status==='inactive'?'bg-yellow-100 text-yellow-700':'bg-gray-100 text-gray-700') }}">{{ ucfirst($span->status) }}</span>
                    </td>
                    <td class="px-4 py-2 text-sm">{{ optional($span->start_date)->format('Y-m-d') }} — {{ optional($span->end_date)->format('Y-m-d') }}</td>
                    <td class="px-4 py-2 text-right">
                        <a href="{{ route('admin.spans.show', $span) }}" class="text-blue-600 hover:text-blue-900 mr-2">View</a>
                        <a href="{{ route('admin.spans.edit', $span) }}" class="text-green-600 hover:text-green-900 mr-2">Edit</a>
                        <form action="{{ route('admin.spans.destroy', $span) }}" method="POST" class="inline" onsubmit="return confirm('Delete span?')">
                            @csrf
                            @method('DELETE')
                            <button class="text-red-600 hover:text-red-900">Delete</button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr><td colspan="7" class="text-center py-10 text-gray-500">No spans found.</td></tr>
            @endforelse
            </tbody>
        </table>
        <div class="p-4">{{ $spans->links() }}</div>
    </div>
</div>
@endsection

