@extends('layouts.admin')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-xl font-semibold">Span Details</h1>
        <a href="{{ route('admin.spans.index') }}" class="px-4 py-2 bg-gray-200 text-gray-800 rounded">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow p-4">
        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div><dt class="text-sm text-gray-500">Name</dt><dd class="text-base">{{ $span->name }}</dd></div>
            <div><dt class="text-sm text-gray-500">Code</dt><dd class="text-base">{{ $span->code }}</dd></div>
            <div><dt class="text-sm text-gray-500">Category</dt><dd class="text-base">{{ $span->category ?? '-' }}</dd></div>
            <div><dt class="text-sm text-gray-500">Owner</dt><dd class="text-base">{{ $span->owner ?? '-' }}</dd></div>
            <div><dt class="text-sm text-gray-500">Status</dt><dd class="text-base">{{ ucfirst($span->status) }}</dd></div>
            <div><dt class="text-sm text-gray-500">Start Date</dt><dd class="text-base">{{ optional($span->start_date)->format('Y-m-d') }}</dd></div>
            <div><dt class="text-sm text-gray-500">End Date</dt><dd class="text-base">{{ optional($span->end_date)->format('Y-m-d') }}</dd></div>
            <div class="md:col-span-2"><dt class="text-sm text-gray-500">Notes</dt><dd class="text-base whitespace-pre-line">{{ $span->notes }}</dd></div>
        </dl>
        <div class="mt-4">
            <a href="{{ route('admin.spans.edit', $span) }}" class="px-4 py-2 bg-green-600 text-white rounded">Edit</a>
        </div>
    </div>
</div>
@endsection
