@extends('layouts.admin')

@section('title', 'Ticket Categories')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Ticket Categories</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage ticket categories and types</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        @if(isset($categories) && is_array($categories))
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($categories as $name => $count)
                    <div class="border rounded-lg p-4">
                        <p class="text-gray-500 text-sm">{{ ucwords(str_replace('_',' ', $name)) }}</p>
                        <p class="text-3xl font-semibold text-gray-900">{{ $count }}</p>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-xs sm:text-sm text-gray-600">No category statistics available.</p>
        @endif
    </div>
</div>
@endsection

