@extends('layouts.admin')

@section('title', 'Edit Ticket')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">Edit Support Ticket</h1>

    <form method="POST" action="{{ route('admin.support.tickets.update', $ticket) }}" class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 space-y-4">
        @csrf
        @method('PUT')

        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Title</label>
                <input type="text" name="title" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" value="{{ old('title', $ticket->title) }}" required>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Priority</label>
                <select name="priority" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    @foreach(['low','medium','high','urgent'] as $p)
                        <option value="{{ $p }}" {{ $ticket->priority === $p ? 'selected' : '' }}>{{ ucfirst($p) }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Category</label>
                <select name="category" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    @foreach(['technical','billing','shipping','complaint','feature_request','other'] as $c)
                        <option value="{{ $c }}" {{ $ticket->category === $c ? 'selected' : '' }}>{{ ucwords(str_replace('_',' ', $c)) }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Assign To</label>
                <select name="assigned_to" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Unassigned</option>
                    @foreach(($users ?? []) as $u)
                        <option value="{{ $u->id }}" {{ $ticket->assigned_to == $u->id ? 'selected' : '' }}>{{ $u->name }} ({{ $u->email }})</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div>
            <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Status</label>
            <select name="status" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                @foreach(['open','pending','in_progress','resolved','closed','escalated'] as $st)
                    <option value="{{ $st }}" {{ $ticket->status === $st ? 'selected' : '' }}>{{ ucwords(str_replace('_',' ', $st)) }}</option>
                @endforeach
            </select>
        </div>
        <div>
            <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Description</label>
            <textarea name="description" rows="5" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>{{ old('description', $ticket->description) }}</textarea>
        </div>
        <div class="flex items-center justify-end gap-2 sm:gap-3">
            <a href="{{ route('admin.support.tickets') }}" class="px-3 sm:px-4 py-2 border border-gray-300 rounded-md text-xs sm:text-sm font-semibold text-gray-700 hover:bg-gray-50 transition">Cancel</a>
            <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update</button>
        </div>
    </form>
</div>
@endsection


