@extends('layouts.admin')

@section('title', 'Escalated Tickets')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Escalated Tickets</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage escalated support tickets</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        @if(isset($tickets) && $tickets->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Ticket #</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">User</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Priority</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Category</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Created</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($tickets as $ticket)
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900">{{ $ticket->ticket_number }}</td>
                                <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $ticket->user->name ?? 'N/A' }}</td>
                                <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ ucfirst($ticket->priority) }}</td>
                                <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ ucfirst($ticket->category) }}</td>
                                <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ $ticket->created_at->format('M d, Y') }}</td>
                                <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium">
                                    <a href="{{ route('admin.support.tickets.show', $ticket) }}" class="text-blue-600 hover:text-blue-900">View</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mt-6">{{ $tickets->links() }}</div>
        @else
            <p class="text-xs sm:text-sm text-gray-600">No escalated tickets found.</p>
        @endif
    </div>
</div>
@endsection


