@extends('layouts.admin')

@section('title', 'Ticket Details')

@section('content')
<div class="container mx-auto px-4 py-6">
    <a href="{{ route('admin.support.tickets') }}" class="text-blue-600">← Back to Tickets</a>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mt-4">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">{{ $ticket->title ?? 'Ticket' }}</h1>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4 text-sm">
            <div>
                <p class="text-gray-500">Ticket #</p>
                <p class="text-gray-900">{{ $ticket->ticket_number ?? $ticket->id }}</p>
            </div>
            <div>
                <p class="text-gray-500">Priority</p>
                <p class="text-gray-900">{{ ucfirst($ticket->priority ?? 'low') }}</p>
            </div>
            <div>
                <p class="text-gray-500">Category</p>
                <p class="text-gray-900">{{ ucwords(str_replace('_',' ', $ticket->category ?? '-')) }}</p>
            </div>
            <div>
                <p class="text-gray-500">Status</p>
                <p>
                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-gray-100 text-gray-800">{{ ucwords(str_replace('_',' ', $ticket->status ?? 'open')) }}</span>
                </p>
            </div>
            <div class="sm:col-span-2">
                <p class="text-gray-500">Description</p>
                <p class="text-gray-900">{{ $ticket->description ?? '-' }}</p>
            </div>
        </div>

        <div class="mt-6 flex gap-2 sm:gap-3">
            <a href="{{ route('admin.support.tickets.edit', $ticket) }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Edit</a>
            <form method="POST" action="{{ route('admin.support.tickets.destroy', $ticket) }}" onsubmit="return confirm('Delete this ticket?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="bg-red-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-red-700 transition">Delete</button>
            </form>
        </div>

        <div class="mt-8">
            <h2 class="text-lg font-semibold mb-2">Add Reply</h2>
            <form method="POST" action="{{ route('admin.support.tickets.reply', $ticket) }}" class="space-y-2">
                @csrf
                <textarea name="message" rows="3" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Write a reply..."></textarea>
                <div class="flex items-center justify-end gap-2 sm:gap-3">
                    <label class="flex items-center text-sm"><input type="checkbox" name="is_internal" class="mr-2">Internal note</label>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Send</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection


