@extends('layouts.admin')

@section('title', 'SLA Management')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">SLA Management</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage Service Level Agreements for tickets</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        @if(isset($slaStats) && is_array($slaStats))
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                <div class="border rounded-lg p-4">
                    <p class="text-gray-500 text-sm">Within SLA</p>
                    <p class="text-3xl font-semibold text-green-600">{{ $slaStats['within_sla'] ?? 0 }}</p>
                </div>
                <div class="border rounded-lg p-4">
                    <p class="text-gray-500 text-sm">Breached SLA</p>
                    <p class="text-3xl font-semibold text-red-600">{{ $slaStats['breached_sla'] ?? 0 }}</p>
                </div>
                <div class="border rounded-lg p-4">
                    <p class="text-gray-500 text-sm">Overdue</p>
                    <p class="text-3xl font-semibold text-yellow-600">{{ $slaStats['overdue'] ?? 0 }}</p>
                </div>
                <div class="border rounded-lg p-4">
                    <p class="text-gray-500 text-sm">Total Tickets</p>
                    <p class="text-3xl font-semibold text-gray-900">{{ $slaStats['total'] ?? 0 }}</p>
                </div>
            </div>
        @else
            <p class="text-xs sm:text-sm text-gray-600">No SLA statistics available.</p>
        @endif
    </div>
</div>
@endsection

