@extends('layouts.app')

@section('title', 'Submit Complaint')

@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Submit Complaint</h1>
        <p class="text-gray-600">Report an issue with your parcel</p>
    </div>

    <form action="{{ route('seller.complaints.store') }}" method="POST" class="bg-white rounded-lg shadow p-6">
        @csrf

        <div class="space-y-6">
            <div>
                <label for="parcel_id" class="block text-sm font-medium text-gray-700">Select Parcel</label>
                <select id="parcel_id" name="parcel_id" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select a parcel</option>
                    @foreach($parcels as $parcel)
                    <option value="{{ $parcel->id }}" {{ request('parcel_id') == $parcel->id ? 'selected' : '' }}>
                        {{ $parcel->tracking_id }} - {{ $parcel->recipient_name }} ({{ $parcel->status }})
                    </option>
                    @endforeach
                </select>
                @error('parcel_id')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div>
                <label for="subject" class="block text-sm font-medium text-gray-700">Subject</label>
                <input type="text" id="subject" name="subject" required 
                       value="{{ old('subject') }}"
                       class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                       placeholder="Brief description of the issue">
                @error('subject')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div>
                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                <textarea id="description" name="description" rows="6" required 
                          class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"
                          placeholder="Provide detailed information about the issue...">{{ old('description') }}</textarea>
                @error('description')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
                <p class="mt-1 text-sm text-gray-500">Minimum 20 characters required</p>
            </div>
        </div>

        <div class="mt-8 flex justify-end gap-4">
            <a href="{{ route('seller.complaints.index') }}" class="px-6 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-red-600 text-white rounded-md hover:bg-red-700">
                Submit Complaint
            </button>
        </div>
    </form>
</div>
@endsection
