@extends('layouts.app')

@section('title', 'Complaint Details')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <a href="{{ route(auth()->user()->role === 'seller' ? 'seller.complaints.index' : 'admin.complaints.index') }}" 
           class="text-blue-600 hover:text-blue-800 mb-4 inline-block">
            ← Back to Complaints
        </a>
        <h1 class="text-3xl font-bold text-gray-900">Complaint Details</h1>
        <p class="text-gray-600">ID: CMP-{{ str_pad($complaint->id, 3, '0', STR_PAD_LEFT) }}</p>
    </div>

    <!-- Status Badge -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-lg font-semibold text-gray-900 mb-2">Status</h2>
                <span class="px-4 py-2 inline-flex text-sm leading-5 font-semibold rounded-full 
                    @if($complaint->status === 'Resolved' || $complaint->status === 'Closed') bg-green-100 text-green-800
                    @elseif($complaint->status === 'In Progress') bg-yellow-100 text-yellow-800
                    @else bg-red-100 text-red-800
                    @endif">
                    {{ $complaint->status }}
                </span>
            </div>
            <div class="text-right">
                <p class="text-sm text-gray-600">Submitted</p>
                <p class="text-lg font-semibold">{{ $complaint->created_at->format('M d, Y') }}</p>
            </div>
        </div>

        @if(auth()->user()->hasAnyRole(['Admin', 'Super Admin', 'Support']) && $complaint->status !== 'Closed')
        <form action="{{ route('admin.complaints.update', $complaint) }}" method="POST" class="mt-6">
            @csrf
            @method('PATCH')
            <div class="flex items-center gap-4">
                <label for="status" class="text-sm font-medium text-gray-700">Update Status:</label>
                <select id="status" name="status" class="px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    <option value="Open" {{ $complaint->status === 'Open' ? 'selected' : '' }}>Open</option>
                    <option value="In Progress" {{ $complaint->status === 'In Progress' ? 'selected' : '' }}>In Progress</option>
                    <option value="Resolved" {{ $complaint->status === 'Resolved' ? 'selected' : '' }}>Resolved</option>
                    <option value="Closed" {{ $complaint->status === 'Closed' ? 'selected' : '' }}>Closed</option>
                </select>
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                    Update
                </button>
            </div>
        </form>
        @endif
    </div>

    <!-- Complaint Information -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Complaint Details</h2>
        <dl class="space-y-4">
            <div>
                <dt class="text-sm font-medium text-gray-500">Subject</dt>
                <dd class="text-base text-gray-900 mt-1">{{ $complaint->subject }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">Description</dt>
                <dd class="text-base text-gray-900 mt-1 whitespace-pre-line">{{ $complaint->description }}</dd>
            </div>
        </dl>
    </div>

    <!-- Related Parcel -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Related Parcel</h2>
        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <dt class="text-sm font-medium text-gray-500">Tracking ID</dt>
                <dd class="text-sm text-blue-600 mt-1">
                    <a href="{{ route(auth()->user()->role === 'seller' ? 'seller.parcels.show' : 'admin.parcels.show', $complaint->parcel) }}">
                        {{ $complaint->parcel->tracking_id }}
                    </a>
                </dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">Recipient</dt>
                <dd class="text-sm text-gray-900 mt-1">{{ $complaint->parcel->recipient_name }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">Status</dt>
                <dd class="text-sm text-gray-900 mt-1">{{ $complaint->parcel->status }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">COD Amount</dt>
                <dd class="text-sm text-gray-900 mt-1">PKR {{ number_format($complaint->parcel->cod_amount, 2) }}</dd>
            </div>
        </dl>
    </div>

    <!-- Seller Information -->
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Submitted By</h2>
        <dl class="space-y-3">
            <div>
                <dt class="text-sm font-medium text-gray-500">Name</dt>
                <dd class="text-sm text-gray-900">{{ $complaint->seller->name }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">Company</dt>
                <dd class="text-sm text-gray-900">{{ $complaint->seller->company_name }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">Email</dt>
                <dd class="text-sm text-gray-900">{{ $complaint->seller->email }}</dd>
            </div>
        </dl>
    </div>
</div>
@endsection
