<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Seller Panel') - Al-wasi Soft Tech CMS</title>
    <script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.store('ui', { sidebarOpen: true });
        });
    </script>
    @stack('styles')
</head>
<body class="bg-gray-100">
    <nav class="bg-white shadow-sm border-b fixed top-0 left-0 right-0 z-30">
        <div class="px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <button @click="$store.ui.sidebarOpen = !$store.ui.sidebarOpen" 
                            class="text-gray-500 hover:text-gray-700 lg:hidden mr-2">
                        <i class="fas fa-bars"></i>
                    </button>
                    <a href="{{ route('seller.dashboard') }}" class="flex items-center">
                        <i class="fas fa-shipping-fast h-8 w-8 text-blue-600"></i>
                        <span class="ml-2 text-xl font-bold text-gray-900 hidden sm:inline">Al-wasi Soft Tech</span>
                    </a>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="text-sm text-gray-700">{{ auth()->user()->name }}</span>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-md text-sm font-medium hover:bg-red-700">Logout</button>
                    </form>
                </div>
            </div>
        </div>
    </nav>

    <div class="flex pt-16" x-data>
        <div x-show="$store.ui.sidebarOpen" class="fixed inset-0 bg-black/30 z-20 lg:hidden" @click="$store.ui.sidebarOpen = false"></div>
        <aside :class="$store.ui.sidebarOpen ? 'translate-x-0' : '-translate-x-full'" 
               class="fixed top-16 bottom-0 left-0 w-64 bg-white border-r transform transition-transform duration-300 ease-in-out z-20 lg:translate-x-0 lg:static">
            @include('partials.seller-sidebar')
        </aside>

        <main class="flex-1 p-6 bg-gray-50">
             @if(session('success'))
                <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif

            @if(session('error'))
                <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('error') }}</span>
                </div>
            @endif
            @yield('content')
        </main>
    </div>
    @stack('scripts')
</body>
</html>
