@extends('layouts.app')

@section('title', 'Book New Parcel')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Book New Parcel</h1>
        <p class="text-gray-600">Fill in the details to book a new parcel for delivery</p>
    </div>

    <form action="{{ route('seller.parcels.store') }}" method="POST" class="bg-white rounded-lg shadow p-6">
        @csrf

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Order Information -->
            <div class="md:col-span-2">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Order Information</h2>
            </div>

            <div>
                <label for="order_type" class="block text-sm font-medium text-gray-700">Order Type</label>
                <select id="order_type" name="order_type" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select Type</option>
                    <option value="COD">Cash on Delivery (COD)</option>
                    <option value="Prepaid">Prepaid</option>
                </select>
                @error('order_type')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div>
                <label for="order_reference_number" class="block text-sm font-medium text-gray-700">Order Reference Number</label>
                <input type="text" id="order_reference_number" name="order_reference_number" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('order_reference_number')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div>
                <label for="cod_amount" class="block text-sm font-medium text-gray-700">COD Amount (PKR)</label>
                <input type="number" id="cod_amount" name="cod_amount" step="0.01" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('cod_amount')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div>
                <label for="booking_date" class="block text-sm font-medium text-gray-700">Booking Date</label>
                <input type="date" id="booking_date" name="booking_date" value="{{ date('Y-m-d') }}" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('booking_date')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <!-- Customer Information -->
            <div class="md:col-span-2 mt-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Customer Information</h2>
            </div>

            <div>
                <label for="recipient_name" class="block text-sm font-medium text-gray-700">Customer Name</label>
                <input type="text" id="recipient_name" name="recipient_name" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('recipient_name')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div>
                <label for="contact" class="block text-sm font-medium text-gray-700">Contact Number</label>
                <input type="text" id="contact" name="contact" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('contact')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <!-- Delivery Information -->
            <div class="md:col-span-2 mt-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Delivery Information</h2>
            </div>

            <div>
                <label for="city" class="block text-sm font-medium text-gray-700">Delivery City</label>
                <input type="text" id="city" name="city" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('city')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div>
                <label for="zone" class="block text-sm font-medium text-gray-700">Zone</label>
                <select id="zone" name="zone" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select Zone</option>
                    <option value="A">Zone A</option>
                    <option value="B">Zone B</option>
                    <option value="C">Zone C</option>
                </select>
                @error('zone')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div class="md:col-span-2">
                <label for="address" class="block text-sm font-medium text-gray-700">Delivery Address</label>
                <textarea id="address" name="address" rows="3" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                @error('address')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <!-- Pickup Information -->
            <div class="md:col-span-2 mt-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Pickup Information</h2>
            </div>

            <div>
                <label for="pickup_city" class="block text-sm font-medium text-gray-700">Pickup City</label>
                <input type="text" id="pickup_city" name="pickup_city" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('pickup_city')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div class="md:col-span-2">
                <label for="pickup_address" class="block text-sm font-medium text-gray-700">Pickup Address</label>
                <textarea id="pickup_address" name="pickup_address" rows="2" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                @error('pickup_address')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <!-- Return Information -->
            <div class="md:col-span-2 mt-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Return Information</h2>
            </div>

            <div>
                <label for="return_city" class="block text-sm font-medium text-gray-700">Return City</label>
                <input type="text" id="return_city" name="return_city" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('return_city')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div class="md:col-span-2">
                <label for="return_address" class="block text-sm font-medium text-gray-700">Return Address</label>
                <textarea id="return_address" name="return_address" rows="2" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                @error('return_address')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <!-- Package Details -->
            <div class="md:col-span-2 mt-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Package Details</h2>
            </div>

            <div>
                <label for="items" class="block text-sm font-medium text-gray-700">Number of Items</label>
                <input type="number" id="items" name="items" min="1" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('items')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div>
                <label for="booking_weight" class="block text-sm font-medium text-gray-700">Weight (kg)</label>
                <input type="number" id="booking_weight" name="booking_weight" step="0.1" min="0.1" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                @error('booking_weight')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div class="md:col-span-2">
                <label for="order_detail" class="block text-sm font-medium text-gray-700">Order Details (Optional)</label>
                <textarea id="order_detail" name="order_detail" rows="2" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                @error('order_detail')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>

            <div class="md:col-span-2">
                <label for="notes" class="block text-sm font-medium text-gray-700">Notes (Optional)</label>
                <textarea id="notes" name="notes" rows="2" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"></textarea>
                @error('notes')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
            </div>
        </div>

        <div class="mt-8 flex justify-end gap-4">
            <a href="{{ route('seller.dashboard') }}" class="px-6 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                Book Parcel
            </button>
        </div>
    </form>
</div>
@endsection
