@extends('layouts.app')

@section('title', 'Track Parcel - ' . $parcel->tracking_id)

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8 text-center">
        <h1 class="text-3xl font-bold text-gray-900">Parcel Tracking</h1>
        <p class="text-gray-600">Tracking ID: <span class="font-semibold">{{ $parcel->tracking_id }}</span></p>
    </div>

    <!-- Status Timeline -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <div class="flex items-center justify-between mb-8">
            <div>
                <h2 class="text-lg font-semibold text-gray-900">Current Status</h2>
                <span class="px-4 py-2 inline-flex text-sm leading-5 font-semibold rounded-full mt-2
                    @if($parcel->status === 'Delivered') bg-green-100 text-green-800
                    @elseif($parcel->status === 'Pending') bg-yellow-100 text-yellow-800
                    @elseif(in_array($parcel->status, ['In Transit', 'Picked Up', 'Out for Delivery'])) bg-blue-100 text-blue-800
                    @else bg-red-100 text-red-800
                    @endif">
                    {{ $parcel->status }}
                </span>
            </div>
        </div>

        <!-- Simple Timeline -->
        <div class="space-y-4">
            <div class="flex items-start">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 rounded-full {{ in_array($parcel->status, ['Pending', 'Picked Up', 'In Transit', 'Out for Delivery', 'Delivered']) ? 'bg-green-500' : 'bg-gray-300' }} flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-semibold text-gray-900">Order Booked</h3>
                    <p class="text-sm text-gray-500">{{ $parcel->booking_date->format('M d, Y') }}</p>
                </div>
            </div>

            <div class="flex items-start">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 rounded-full {{ in_array($parcel->status, ['Picked Up', 'In Transit', 'Out for Delivery', 'Delivered']) ? 'bg-green-500' : 'bg-gray-300' }} flex items-center justify-center">
                        @if(in_array($parcel->status, ['Picked Up', 'In Transit', 'Out for Delivery', 'Delivered']))
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                        </svg>
                        @endif
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-semibold text-gray-900">Picked Up</h3>
                    <p class="text-sm text-gray-500">{{ in_array($parcel->status, ['Picked Up', 'In Transit', 'Out for Delivery', 'Delivered']) ? 'Completed' : 'Pending' }}</p>
                </div>
            </div>

            <div class="flex items-start">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 rounded-full {{ in_array($parcel->status, ['In Transit', 'Out for Delivery', 'Delivered']) ? 'bg-green-500' : 'bg-gray-300' }} flex items-center justify-center">
                        @if(in_array($parcel->status, ['In Transit', 'Out for Delivery', 'Delivered']))
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                        </svg>
                        @endif
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-semibold text-gray-900">In Transit</h3>
                    <p class="text-sm text-gray-500">{{ in_array($parcel->status, ['In Transit', 'Out for Delivery', 'Delivered']) ? 'Completed' : 'Pending' }}</p>
                </div>
            </div>

            <div class="flex items-start">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 rounded-full {{ $parcel->status === 'Delivered' ? 'bg-green-500' : 'bg-gray-300' }} flex items-center justify-center">
                        @if($parcel->status === 'Delivered')
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                        </svg>
                        @endif
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-semibold text-gray-900">Delivered</h3>
                    <p class="text-sm text-gray-500">{{ $parcel->status === 'Delivered' ? 'Completed' : 'Pending' }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Delivery Information -->
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Delivery Information</h2>
        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <dt class="text-sm font-medium text-gray-500">Recipient</dt>
                <dd class="text-sm text-gray-900">{{ $parcel->recipient_name }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">Contact</dt>
                <dd class="text-sm text-gray-900">{{ $parcel->contact }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">City</dt>
                <dd class="text-sm text-gray-900">{{ $parcel->city }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500">COD Amount</dt>
                <dd class="text-sm text-gray-900 font-semibold">PKR {{ number_format($parcel->cod_amount, 2) }}</dd>
            </div>
            <div class="md:col-span-2">
                <dt class="text-sm font-medium text-gray-500">Address</dt>
                <dd class="text-sm text-gray-900">{{ $parcel->address }}</dd>
            </div>
        </dl>
    </div>
</div>
@endsection
