<aside id="sidebar" class="w-56 bg-white border-r border-gray-200 min-h-screen fixed left-0 top-16 bottom-0 overflow-y-auto z-20">
    
    <nav class="py-2">
        <div class="mb-1">
            <h3 class="px-3 py-2 font-semibold text-primary uppercase text-xs tracking-wider">OVERVIEW</h3>
            <div class="flex flex-col gap-1">
                <a href="{{ route('admin.dashboard') }}" 
                   class="flex items-center px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50 {{ request()->routeIs('admin.dashboard') ? 'bg-blue-50 text-blue-600 font-bold border-r-4 border-blue-600' : '' }}">
                    <i class="fas fa-home w-5 h-5 mr-3"></i>
                    <span>Dashboard</span>
                </a>
                <a href="{{ route('admin.parcels.index') }}" 
                   class="flex items-center px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50 {{ request()->routeIs('admin.parcels.index') ? 'bg-blue-50 text-blue-600 font-bold border-r-4 border-blue-600' : '' }}">
                    <i class="fas fa-truck w-5 h-5 mr-3"></i>
                    <span>Shipments</span>
                </a>
                <a href="{{ route('admin.spans.index') }}" 
                   class="flex items-center px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50 {{ request()->routeIs('admin.spans.*') ? 'bg-blue-50 text-blue-600 font-bold border-r-4 border-blue-600' : '' }}">
                    <i class="fas fa-layer-group w-5 h-5 mr-3"></i>
                    <span>Spans</span>
                </a>
            </div>
        </div>

        <div class="mb-1">
            <h3 class="px-3 py-2 font-semibold text-primary uppercase text-xs tracking-wider">MERCHANTS</h3>
            <div class="flex flex-col gap-1">
                <a href="{{ route('admin.merchants.index') }}" 
                   class="flex items-center px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50 {{ request()->routeIs('admin.merchants.index') ? 'bg-blue-50 text-blue-600 font-bold border-r-4 border-blue-600' : '' }}">
                    <i class="fas fa-users w-5 h-5 mr-3"></i>
                    <span>Merchants</span>
                </a>
            </div>
        </div>

        <!-- FINANCE, TAX & ACCOUNTING -->
        @if($showFinance)
        <div class="mb-3">
            <p class="px-4 text-[10px] font-semibold text-gray-700 uppercase tracking-wider mb-1.5">FINANCE, TAX & ACCOUNTING</p>
            <!-- Cash & COD Management - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                        <span>Cash & COD Management</span>
                    </div>
                    <svg class="w-3 h-3 transform transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ url('finance/cod/daily-collection') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Daily Cash Collection
                    </a>
                    <a href="{{ url('finance/cod/deposits') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Deposits to Bank
                    </a>
                    <a href="{{ url('finance/cod/pending-report') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Pending COD Report
                    </a>
                    <a href="{{ url('finance/cod/variance-report') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        COD Variance Report
                    </a>
                </div>
            </div>
            <!-- Merchant Settlements - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                        </svg>
                        <span>Merchant Settlements</span>
                    </div>
                    <svg class="w-3 h-3 transform transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ route('finance.settlements.invoices.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Invoices
                    </a>
                    <a href="{{ route('finance.settlements.payments.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Payments to Merchants
                    </a>
                    <a href="{{ route('finance.settlements.deductions.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Deductions
                    </a>
                    <a href="{{ route('finance.settlements.pending-report') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Pending Settlement Report
                    </a>
                    <a href="{{ route('finance.settlements.disputes.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Dispute Management
                    </a>
                </div>
            </div>
            <!-- Company Accounting - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        <span>Company Accounting</span>
                    </div>
                    <svg class="w-3 h-3 transform transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ url('finance/accounting/chart-of-accounts') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Chart of Accounts
                    </a>
                    <a href="{{ url('finance/accounting/journal-entries') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Journal Entries
                    </a>
                    <a href="{{ url('finance/accounting/ledger') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Ledger View
                    </a>
        <a href="{{ route('finance.accounting.trial-balance') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
            Trial Balance
        </a>
                    <a href="{{ url('finance/accounting/balance-sheet') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Balance Sheet
                    </a>
                    <a href="{{ url('finance/accounting/profit-loss') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Profit & Loss Statement
                    </a>
                </div>
            </div>
            <!-- Expenses & Payments - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                        </svg>
                        <span>Expenses & Payments</span>
                    </div>
                    <svg class="w-3 h-3 transform transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ url('finance/expenses/company') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Company Expenses
                    </a>
                    <a href="{{ url('finance/expenses/branch') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Branch Level Expenses
                    </a>
                    <a href="{{ url('finance/expenses/vendor-payments') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Vendor Payments
                    </a>
                    <a href="{{ url('finance/expenses/approval-flow') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Expense Approval Flow
                    </a>
                    <a href="{{ url('finance/expenses/recurring') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Recurring Expenses
                    </a>
                </div>
            </div>
            <!-- Payroll & Salaries - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <span>Payroll & Salaries</span>
                    </div>
                    <svg class="w-3 h-3 transform transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ url('finance/payroll/employee-master') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Employee Master Data
                    </a>
                    <a href="{{ url('finance/payroll/attendance') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Attendance & Overtime
                    </a>
                    <a href="{{ url('finance/payroll/payroll-run') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Payroll Run
                    </a>
                    <a href="{{ route('finance.payroll.tax-deductions') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Tax Deductions
                    </a>
                    <a href="{{ route('finance.payroll.salary-slips') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Salary Slips
                    </a>
                    <a href="{{ route('finance.payroll.bonus-incentives') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Bonus & Incentives
                    </a>
                </div>
            </div>
            <!-- Taxation & Compliance - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        <span>Taxation & Compliance</span>
                    </div>
                    <svg class="w-3 h-3 transform transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ url('finance/taxation/gst-calculation') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        GST Calculation
                    </a>
                    <a href="{{ url('finance/taxation/income-tax') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Income Tax Withholding
                    </a>
                    <a href="{{ url('finance/taxation/filings') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Tax Filings
                    </a>
                    <a href="{{ url('finance/taxation/e-filing') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        e-Filing Integration
                    </a>
                    <a href="{{ url('finance/taxation/deduction-reports') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Tax Deduction Reports
                    </a>
                    <a href="{{ url('finance/taxation/calendar-alerts') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Tax Calendar Alerts
                    </a>
                </div>
            </div>
            <!-- Banking & Reconciliation - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                        <span>Banking & Reconciliation</span>
                    </div>
                    <svg class="w-3 h-3 transform transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ url('finance/banking/accounts') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Bank Accounts Linked
                    </a>
                    <a href="{{ url('finance/banking/reconciliation') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Bank Reconciliation
                    </a>
                    <a href="{{ url('finance/banking/cheques') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Cheque Management
                    </a>
                    <a href="{{ url('finance/banking/discrepancies') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Discrepancy Alerts
                    </a>
                </div>
            </div>
            <!-- Vouchers & Manual Entry - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        <span>Vouchers & Manual Entry</span>
                    </div>
                    <svg class="w-3 h-3 transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ url('finance/vouchers/cash-payment') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Cash Payment Voucher
                    </a>
                    <a href="{{ url('finance/vouchers/bank-payment') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Bank Payment Voucher
                    </a>
                    <a href="{{ url('finance/vouchers/cash-receipt') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Cash Receipt Voucher
                    </a>
                    <a href="{{ url('finance/vouchers/bank-receipt') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Bank Receipt Voucher
                    </a>
                    <a href="{{ url('finance/vouchers/journal') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Journal Voucher
                    </a>
                    <a href="{{ url('finance/vouchers/contra') }}" class=
                        Contra Voucher
                    </a>
                </div>
            </div>
            <!-- Audit & Controls - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/>
                        </svg>
                        <span>Audit & Controls</span>
                    </div>
                    <svg class="w-3 h-3 transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ url('finance/audit/internal-audit') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Internal Audit Reports
                    </a>
                    <a href="{{ url('finance/audit/external-audit') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        External Audit Interface
                    </a>
                    <a href="{{ url('finance/audit/compliance') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Compliance Checks
                    </a>
                    <a href="{{ url('finance/audit/sox') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        SOX Compliance
                    </a>
                    <a href="{{ url('finance/audit/risk-assessment') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Risk Assessment
                    </a>
                    <a href="{{ url('finance/audit/access-controls') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Access Control Logs
                    </a>
                </div>
            </div>
            <!-- Reports & Analytics - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                        </svg>
                        <span>Reports & Analytics</span>
                    </div>
                    <svg class="w-3 h-3 transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ url('finance/reports/financial') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Financial Reports
                    </a>
                    <a href="{{ url('finance/reports/operational') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Operational Reports
                    </a>
                    <a href="{{ url('finance/reports/custom') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Custom Reports
                    </a>
                    <a href="{{ url('finance/reports/export') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Export Center
                    </a>
                    <a href="{{ url('finance/reports/dashboard') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Report Dashboard
                    </a>
                    <a href="{{ url('finance/reports/schedule') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Scheduled Reports
                    </a>
                </div>
            </div>
        </div>
        @endif

        <!-- MARKETING & SALES -->
        @if($showMarketing)
        <div class="mb-3">
            <p class="px-4 text-[10px] font-semibold text-gray-700 uppercase tracking-wider mb-1.5">MARKETING & SALES</p>
            <a href="{{ route('admin.marketing.dashboard') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                </svg>
                Dashboard
            </a>
            <a href="{{ route('admin.marketing.alerts') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
                </svg>
                Alerts
            </a>
            <a href="{{ route('admin.marketing.management') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                </svg>
                Management
            </a>
            <!-- Rates & Documents - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        <span>Rates & Documents</span>
                    </div>
                    <svg class="w-3 h-3 transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ route('admin.marketing.rates.pricing.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Pricing Management
                    </a>
                    <a href="{{ route('admin.marketing.rates.discounts.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Discount & Promotions
                    </a>
                    <a href="{{ route('admin.marketing.rates.zones.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Zone-based Rates
                    </a>
                <a href="{{ route('admin.marketing.documents.templates.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Document Templates
                    </a>
                    <a href="{{ route('admin.marketing.documents.contracts.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Contract Management
                    </a>
                    <a href="{{ route('admin.marketing.documents.compliance.index') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Compliance Documents
                    </a>
                </div>
            </div>
            <a href="{{ route('admin.complaints.index') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                </svg>
                Complaints
            </a>
        </div>

        @endif

        <!-- SUPPORT & COMPLAINTS -->
        @if($showSupport)
        <div class="mb-3">
            <p class="px-4 text-[10px] font-semibold text-gray-700 uppercase tracking-wider mb-1.5">SUPPORT & COMPLAINTS</p>
            <a href="{{ route('admin.support.dashboard') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                </svg>
                Dashboard
            </a>
            <!-- Tickets - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"/>
                        </svg>
                        <span>Tickets</span>
                    </div>
                    <svg class="w-3 h-3 transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ route('admin.support.tickets.open') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Open Tickets
                    </a>
                    <a href="{{ route('admin.support.tickets.pending') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Pending Tickets
                    </a>
                    <a href="{{ route('admin.support.tickets.resolved') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Resolved Tickets
                    </a>
                    <a href="{{ route('admin.support.tickets.escalated') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Escalated Tickets
                    </a>
                    <a href="{{ route('admin.support.tickets.categories') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Ticket Categories
                    </a>
                    <a href="{{ route('admin.support.tickets.sla') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        SLA Management
                    </a>
                </div>
            </div>
        </div>
        @endif

        <!-- RIDER OPS -->
        @if($isAdmin || $isSuperAdmin)
        <div class="mb-3">
            <p class="px-4 text-[10px] font-semibold text-gray-700 uppercase tracking-wider mb-1.5">RIDER OPS</p>
            <a href="{{ route('admin.riders.dashboard') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                </svg>
                Dashboard
            </a>
            <!-- Rider Management - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        <span>Rider Management</span>
                    </div>
                    <svg class="w-3 h-3 transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ route('admin.riders.profiles') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        All Riders
                    </a>
                    <a href="{{ route('admin.riders.attendance') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Rider Attendance
                    </a>
                    <a href="{{ route('admin.riders.gps-tracking') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        GPS Tracking
                    </a>
                    <a href="{{ route('admin.riders.performance.efficiency') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Performance Metrics
                    </a>
                    <a href="{{ route('admin.riders.finance.cash-collection') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Cash Collection
                    </a>
                    <a href="{{ route('admin.riders.finance.pending-cod') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Pending COD
                    </a>
                </div>
            </div>
            <!-- Delivery Operations - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                        <span>Delivery Operations</span>
                    </div>
                    <svg class="w-3 h-3 transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ route('admin.riders.assign-parcels') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Assign Parcels
                    </a>
                    <a href="{{ route('admin.logistics.routing-efficiency') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Route Optimization
                    </a>
                    <a href="{{ route('admin.riders.gps-tracking') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Real-time Tracking
                    </a>
                    <a href="{{ route('admin.logistics.vehicle-dispatch') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Vehicle Dispatch
                    </a>
                    <a href="{{ route('branch.deliveries-assigned') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Assigned Deliveries
                    </a>
                    <a href="{{ route('branch.successful-deliveries') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Successful Deliveries
                    </a>
                </div>
            </div>
        </div>
        @endif

        <!-- HR & EMPLOYEES -->
        @if($isAdmin || $isSuperAdmin)
        <div class="mb-3">
            <p class="px-4 text-[10px] font-semibold text-gray-700 uppercase tracking-wider mb-1.5">HR & EMPLOYEES</p>
            <a href="{{ route('admin.hr.dashboard') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                </svg>
                Dashboard
            </a>
            <!-- Employee Directory - Expandable -->
            <div x-data="{ open: false }" class="mb-1">
                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-xs font-medium text-gray-900 hover:bg-blue-50 rounded-sm bg-gray-50">
                    <div class="flex items-center">
                        <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                        <span>Employee Directory</span>
                    </div>
                    <svg class="w-3 h-3 transition-transform" :class="{'rotate-180': open}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="open" x-transition class="ml-6 mt-1 space-y-0.5">
                    <a href="{{ route('admin.hr.documents') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Employee Documents
                    </a>
                    <a href="{{ route('admin.hr.recruitment') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Recruitment & Hiring
                    </a>
                    <a href="{{ route('admin.hr.attendance') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Attendance Management
                    </a>
                    <a href="{{ route('admin.hr.leaves') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Leave Management
                    </a>
                    <a href="{{ route('admin.hr.performance-kpis') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Performance KPIs
                    </a>
                    <a href="{{ route('admin.hr.training') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Training Programs
                    </a>
                    <a href="{{ route('admin.hr.exit-handover') }}" class="block px-3 py-1 text-[11px] text-gray-600 hover:text-blue-600 hover:bg-blue-50 rounded-sm">
                        Exit & Handover
                    </a>
                </div>
            </div>
        </div>
        @endif

        <!-- BRANCH OPERATIONS -->
        @if($showBranchOps)
        <div class="mb-3">
            <p class="px-4 text-[10px] font-semibold text-gray-700 uppercase tracking-wider mb-1.5">BRANCH OPERATIONS</p>
            <a href="{{ route('branch.bagging') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                </svg>
                Bagging
            </a>
            <a href="{{ route('branch.dispatch') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                </svg>
                Dispatch Shipments
            </a>
        </div>
        @endif

        <!-- SYSTEM SETTINGS & CONTROL -->
        @if($isSuperAdmin)
        <div class="mb-3 pb-6">
            <p class="px-4 text-[10px] font-semibold text-gray-700 uppercase tracking-wider mb-1.5">SYSTEM SETTINGS & CONTROL</p>
            <a href="{{ route('admin.settings.users') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                </svg>
                User Roles & Permissions
            </a>
            <a href="{{ route('admin.settings.security') }}" class="flex items-center px-3 py-1.5 text-xs text-gray-700 hover:bg-gray-50">
                <svg class="w-3.5 h-3.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                </svg>
                Security & Backups
            </a>
        </div>
        @endif
        
        <!-- Bottom Padding for Scroll Space -->
        <div class="h-20"></div>
    </nav>
    
    <!-- Scroll to Top Button -->
    <button id="scrollToTop" 
            class="hidden sticky bottom-4 left-0 right-0 mx-auto w-10 h-10 bg-blue-600 text-white rounded-full shadow-lg hover:bg-blue-700 transition-all z-30"
            title="Scroll to top"
            aria-label="Scroll to top">
        <svg class="w-5 h-5 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"/>
        </svg>
    </button>
</aside>

