<aside id="sidebar" class="w-56 bg-white border-r border-gray-200 min-h-screen fixed left-0 top-16 bottom-0 overflow-y-auto z-20" x-data="{ open: '' }">
    <nav class="py-2">
        @php
            $sellerMenuGroups = [
                [
                    'title' => 'OVERVIEW',
                    'items' => [
                        ['href' => 'seller.dashboard', 'label' => 'Dashboard', 'icon' => 'fa-home'],
                    ]
                ],
                [
                    'title' => 'ORDERS',
                    'items' => [
                        ['href' => 'seller.orders.create', 'label' => 'Create Order', 'icon' => 'fa-plus-circle'],
                        ['href' => 'seller.orders.index', 'label' => 'Manage Orders', 'icon' => 'fa-tasks'],
                        ['href' => 'seller.orders.bulk-upload', 'label' => 'Bulk Upload', 'icon' => 'fa-cloud-upload-alt'],
                    ]
                ],
                [
                    'title' => 'SHIPMENTS',
                    'items' => [
                        ['href' => 'seller.shipments.index', 'label' => 'All Shipments', 'icon' => 'fa-truck'],
                        ['href' => 'seller.shipments.track', 'label' => 'Track Shipment', 'icon' => 'fa-search-location'],
                    ]
                ],
                [
                    'title' => 'FINANCE',
                    'items' => [
                        ['href' => 'seller.payments.invoices', 'label' => 'Invoices', 'icon' => 'fa-file-invoice-dollar'],
                        ['href' => 'seller.payments.settlements', 'label' => 'Settlements', 'icon' => 'fa-wallet'],
                    ]
                ],
                [
                    'title' => 'REPORTS',
                    'items' => [
                        ['href' => 'seller.reports.orders', 'label' => 'Order Reports', 'icon' => 'fa-chart-bar'],
                        ['href' => 'seller.reports.financial', 'label' => 'Financial Reports', 'icon' => 'fa-chart-pie'],
                    ]
                ],
                [
                    'title' => 'SUPPORT',
                    'items' => [
                        ['href' => 'seller.complaints.index', 'label' => 'My Complaints', 'icon' => 'fa-comment-dots'],
                    ]
                ],
                [
                    'title' => 'SETTINGS',
                    'items' => [
                        ['href' => 'seller.settings.profile', 'label' => 'Profile', 'icon' => 'fa-user-cog'],
                        ['href' => 'seller.settings.integrations', 'label' => 'Integrations', 'icon' => 'fa-cogs'],
                    ]
                ],
            ];
        @endphp

        @foreach ($sellerMenuGroups as $group)
            <div class="mb-1">
                <h3 class="px-3 py-2 font-semibold text-primary uppercase text-xs tracking-wider">{{ $group['title'] }}</h3>
                <div class="flex flex-col gap-1">
                    @foreach ($group['items'] as $item)
                        <a href="{{ route($item['href']) }}"
                           class="flex items-center px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50 {{ request()->routeIs($item['href']) ? 'bg-blue-50 text-blue-600 font-bold border-r-4 border-blue-600' : '' }}">
                            <i class="fas {{ $item['icon'] }} w-5 h-5 mr-3"></i>
                            <span>{{ $item['label'] }}</span>
                        </a>
                    @endforeach
                </div>
            </div>
        @endforeach
    </nav>
</aside>
