@extends('layouts.seller')

@section('title', 'My Complaints')

@section('content')
<div class="space-y-8">
    <div class="bg-white p-6 rounded-lg shadow-md" x-data="complaintForm()">
        <div class="flex flex-wrap items-center justify-between gap-4 mb-4">
            <h2 class="text-xl font-bold text-gray-800">Complaint Request</h2>
            <div class="flex items-center gap-2">
                <label for="consignment_number" class="text-sm font-medium">Consignment Note Number</label>
                <input type="text" x-model="trackingId" @keydown.enter.prevent="searchParcel" placeholder="Enter Consignment Number" class="border-gray-300 rounded-md shadow-sm">
                <button @click="searchParcel" :disabled="isLoading" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">
                    <i class="fas fa-search mr-2"></i> <span x-text="isLoading ? 'Searching...' : 'Search'"></span>
                </button>
            </div>
        </div>

        <div class="p-4 border rounded-lg bg-gray-50">
            <p class="text-sm font-semibold border-b pb-2 mb-4">Consignment Information</p>
            <template x-if="!parcel">
                <div class="flex items-center justify-center h-64 border-2 border-dashed rounded-lg bg-gray-100">
                    <p class="text-gray-500">Search for a consignment to view its details.</p>
                </div>
            </template>
            <template x-if="parcel">
                <form action="{{ route('seller.complaints.store') }}" method="POST">
                    @csrf
                    <input type="hidden" name="order_id" :value="parcel.id">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-4">
                        <div class="space-y-4">
                            <div>
                                <label class="text-sm font-medium text-gray-500">Booking Date</label>
                                <input type="text" :value="new Date(parcel.created_at).toLocaleDateString()" class="mt-1 bg-gray-100 w-full border-gray-300 rounded-md shadow-sm" readonly>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Consignee Name</label>
                                <input type="text" :value="parcel.recipient_name" class="mt-1 bg-gray-100 w-full border-gray-300 rounded-md shadow-sm" readonly>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Delivery Status</label>
                                <input type="text" :value="parcel.status" class="mt-1 bg-gray-100 w-full border-gray-300 rounded-md shadow-sm" readonly>
                            </div>
                        </div>
                        <div class="space-y-4">
                            <div>
                                <label class="text-sm font-medium text-gray-500">Destination</label>
                                <input type="text" :value="parcel.recipient_city" class="mt-1 bg-gray-100 w-full border-gray-300 rounded-md shadow-sm" readonly>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">Consignee Contact</label>
                                <input type="text" :value="parcel.recipient_phone" class="mt-1 bg-gray-100 w-full border-gray-300 rounded-md shadow-sm" readonly>
                            </div>
                            <div>
                                <label class="text-sm font-medium text-gray-500">COD Amount</label>
                                <input type="text" :value="'PKR ' + parcel.cod_amount" class="mt-1 bg-gray-100 w-full border-gray-300 rounded-md shadow-sm" readonly>
                            </div>
                        </div>
                        <div class="md:col-span-2">
                            <label for="subject" class="text-sm font-medium text-gray-700">Subject</label>
                            <input type="text" name="subject" id="subject" class="mt-1 w-full border-gray-300 rounded-md shadow-sm" required>
                        </div>
                        <div class="md:col-span-2">
                            <label for="description" class="text-sm font-medium text-gray-700">Complaint Details</label>
                            <textarea name="description" id="description" rows="3" class="mt-1 w-full border-gray-300 rounded-md shadow-sm" required></textarea>
                        </div>
                    </div>
                    <div class="mt-6 border-t pt-6 flex justify-end">
                        <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-md font-semibold">File Complaint</button>
                    </div>
                </form>
            </template>
        </div>
    </div>

    <div class="bg-white p-6 rounded-lg shadow-md">
        <h2 class="text-xl font-bold text-gray-800 mb-4">Support Tickets</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead>
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ticket ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Subject</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Action</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse ($complaints as $complaint)
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-blue-600">TKT-{{ $complaint->id }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $complaint->subject }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $complaint->order->tracking_id ?? 'N/A' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $complaint->created_at->format('d M, Y') }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">{{ $complaint->status }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <a href="{{ route('seller.complaints.show', $complaint) }}" class="text-blue-600 hover:text-blue-900">View Details</a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-10 text-sm text-gray-500">No complaints found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
            <div class="mt-4">
                {{ $complaints->links() }}
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function complaintForm() {
        return {
            trackingId: '',
            parcel: null,
            isLoading: false,
            searchParcel() {
                if (!this.trackingId) return;
                this.isLoading = true;
                fetch('{{ route("seller.complaints.search-parcel") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ tracking_id: this.trackingId })
                })
                .then(res => res.json())
                .then(data => {
                    this.parcel = data;
                    if (!data) {
                        alert('No consignment found with this number.');
                    }
                })
                .catch(() => alert('An error occurred.'))
                .finally(() => this.isLoading = false);
            }
        }
    }
</script>
@endpush
@endsection
