@extends('layouts.seller')

@section('title', 'Help & FAQ')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6 text-center">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Help & FAQ</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Find answers to common questions.</p>
    </div>

    <div class="bg-white rounded-lg shadow-md max-w-3xl mx-auto" x-data="{ open: 'faq-1' }">
        <div class="p-4 sm:p-6 border-b">
            <h2 class="text-lg font-semibold">Frequently Asked Questions</h2>
        </div>
        <div class="p-4 sm:p-6">
            <!-- FAQ Item 1 -->
            <div class="border-b pb-4 mb-4">
                <button @click="open = open === 'faq-1' ? '' : 'faq-1'" class="w-full flex justify-between items-center text-left">
                    <span class="font-semibold text-gray-800">How do I book a parcel?</span>
                    <svg class="w-5 h-5 transform transition-transform" :class="{ 'rotate-180': open === 'faq-1' }" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open === 'faq-1'" x-collapse class="mt-2 text-sm text-gray-600">
                    <p>You can book a parcel by navigating to the "Book New Parcel" page from the sidebar. Fill in the sender, recipient, and parcel details, then click "Book Parcel".</p>
                </div>
            </div>

            <!-- FAQ Item 2 -->
            <div class="border-b pb-4 mb-4">
                <button @click="open = open === 'faq-2' ? '' : 'faq-2'" class="w-full flex justify-between items-center text-left">
                    <span class="font-semibold text-gray-800">When will I receive my COD payment?</span>
                    <svg class="w-5 h-5 transform transition-transform" :class="{ 'rotate-180': open === 'faq-2' }" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open === 'faq-2'" x-collapse class="mt-2 text-sm text-gray-600">
                    <p>COD payments are typically cleared within 3-5 business days after the parcel is successfully delivered. The amount will then be reflected in your "Available for Payout" balance.</p>
                </div>
            </div>

            <!-- FAQ Item 3 -->
            <div class="border-b pb-4 mb-4">
                <button @click="open = open === 'faq-3' ? '' : 'faq-3'" class="w-full flex justify-between items-center text-left">
                    <span class="font-semibold text-gray-800">How can I track my shipment?</span>
                    <svg class="w-5 h-5 transform transition-transform" :class="{ 'rotate-180': open === 'faq-3' }" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div x-show="open === 'faq-3'" x-collapse class="mt-2 text-sm text-gray-600">
                    <p>Use the "Track Shipment" page and enter your parcel's tracking ID. You can also view the status of all your shipments on the "My Parcels" page.</p>
                </div>
            </div>
            
        </div>
    </div>
</div>
@endsection
