@extends('layouts.seller')

@section('title', 'Invoices')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Invoices</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Review and download your shipment invoices.</p>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 mb-4 sm:mb-6">
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-3 sm:gap-4 items-end">
            <div>
                <label for="status" class="block text-[11px] font-medium text-gray-700 mb-1">Status</label>
                <select id="status" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Statuses</option>
                    <option value="Paid">Paid</option>
                    <option value="Unpaid">Unpaid</option>
                    <option value="Overdue">Overdue</option>
                </select>
            </div>
            <div>
                <label for="date_range" class="block text-[11px] font-medium text-gray-700 mb-1">Date Range</label>
                <input type="date" id="date_range" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            <div>
                <button class="w-full bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-gray-800 transition">Apply Filters</button>
            </div>
        </div>
    </div>

    <!-- Invoices Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Invoice ID</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @php
                        $statuses = [
                            'Paid' => 'bg-green-100 text-green-800',
                            'Unpaid' => 'bg-yellow-100 text-yellow-800',
                            'Overdue' => 'bg-red-100 text-red-800',
                        ];
                    @endphp
                    @for ($i = 0; $i < 7; $i++)
                    @php 
                        $status = array_rand($statuses);
                    @endphp
                    <tr>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-blue-600">
                            <a href="#">INV-{{ rand(1000, 9999) }}-{{ now()->subWeeks($i)->format('Ym') }}</a>
                        </td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ now()->subWeeks($i)->format('d M, Y') }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right text-gray-900">PKR {{ number_format(rand(5000, 25000), 2) }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap">
                            <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full {{ $statuses[$status] }}">
                                {{ $status }}
                            </span>
                        </td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-right text-xs font-medium">
                            <a href="#" class="text-blue-600 hover:text-blue-900">Download</a>
                        </td>
                    </tr>
                    @endfor
                </tbody>
            </table>
        </div>
        <!-- Pagination -->
        <div class="px-4 py-3 border-t">
            <p class="text-xs text-gray-600">Pagination placeholder</p>
        </div>
    </div>
</div>
@endsection
