@extends('layouts.seller')

@section('title', 'Generate Load Sheet')

@section('content')
<form action="{{ route('seller.load-sheet.store') }}" method="POST" x-data="{ selectedOrders: [] }">
    @csrf
    <div class="space-y-8">
        <div class="flex items-center justify-end">
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold" :disabled="selectedOrders.length === 0">
                <i class="fas fa-plus-circle mr-2"></i>
                Generate LoadSheet (<span x-text="selectedOrders.length"></span>)
            </button>
        </div>
        <div class="bg-white rounded-lg shadow-md">
            <div class="p-4 border-b">
                <div class="flex flex-wrap items-center justify-between gap-4">
                    <div class="flex items-center gap-4 flex-wrap">
                        <div class="flex-1 min-w-[200px]">
                            <label class="text-sm font-medium">Booking Date From</label>
                            <input type="date" name="from_date" value="{{ request('from_date') }}" class="w-full border-gray-300 rounded-md shadow-sm mt-1">
                        </div>
                        <div class="flex-1 min-w-[200px]">
                            <label class="text-sm font-medium">Booking Date To</label>
                            <input type="date" name="to_date" value="{{ request('to_date') }}" class="w-full border-gray-300 rounded-md shadow-sm mt-1">
                        </div>
                    </div>
                    <div class="flex items-end gap-2">
                        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-sync-alt"></i></button>
                        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-cloud-upload-alt"></i></button>
                        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-download"></i></button>
                        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-print"></i></button>
                        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-cog"></i></button>
                    </div>
                </div>
            </div>
            <div class="p-6 space-y-6">
                <div class="p-4 border rounded-lg bg-gray-50">
                    <p class="text-sm font-semibold mb-4">ADVANCED SEARCH</p>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                        <div class="lg:col-span-1">
                            <label class="text-xs text-gray-500">Search by</label>
                            <div class="flex">
                                <input type="text" name="search" value="{{ request('search') }}" placeholder="Search..." class="w-full border-gray-300 rounded-l-md shadow-sm">
                                <select name="search_type" class="w-auto min-w-[150px] border-gray-300 rounded-r-md shadow-sm border-l-0">
                                    <option value="tracking_id" @selected(request('search_type') == 'tracking_id')>TRACKING #</option>
                                    <option value="recipient_name" @selected(request('search_type') == 'recipient_name')>NAME</option>
                                </select>
                            </div>
                        </div>
                        <div>
                            <label class="text-xs text-gray-500">CITY</label>
                            <select name="city" class="w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">Select City</option>
                            </select>
                        </div>
                        <div class="flex items-end gap-2">
                            <button type="submit" formaction="{{ route('seller.load-sheet.create') }}" formmethod="GET" class="w-full bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">Search</button>
                            <a href="{{ route('seller.load-sheet.create') }}" class="w-full bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold text-center">Clear Filter</a>
                        </div>
                    </div>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left"><input type="checkbox" @click="selectedOrders = $event.target.checked ? {{ json_encode($orders->pluck('id')) }} : []"></th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order Ref</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tracking #</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">City</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($orders as $order)
                            <tr>
                                <td class="px-6 py-4"><input type="checkbox" name="orders[]" value="{{ $order->id }}" x-model="selectedOrders"></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $order->order_ref ?? 'N/A' }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-blue-600">{{ $order->tracking_id }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">{{ $order->status }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $order->recipient_name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $order->recipient_city }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 text-right">PKR {{ number_format($order->cod_amount, 2) }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center py-10 text-sm text-gray-500">No orders found for the selected criteria.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                    <div class="mt-4">
                        {{ $orders->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection
