<!DOCTYPE html>
<html>
<head>
    <title>Airway Bills</title>
    <style>
        body { font-family: sans-serif; }
        .page-break { page-break-after: always; }
        .airway-bill { border: 1px solid #000; padding: 15px; margin-bottom: 20px; }
        h1, h2 { margin-top: 0; }
    </style>
</head>
<body>
    @foreach($orders as $order)
        <div class="airway-bill">
            <h1>Airway Bill</h1>
            <h2>Order ID: {{ $order->tracking_id }}</h2>
            <p><strong>Recipient:</strong> {{ $order->recipient_name }}</p>
            <p><strong>Address:</strong> {{ $order->recipient_address }}</p>
            <p><strong>Phone:</strong> {{ $order->recipient_phone }}</p>
            <p><strong>COD Amount:</strong> PKR {{ number_format($order->cod_amount, 2) }}</p>
        </div>
        @if(!$loop->last)
            <div class="page-break"></div>
        @endif
    @endforeach
</body>
</html>
