@extends('layouts.seller')

@section('title', 'Create Order')

@section('content')
<div class="bg-white p-6 rounded-lg shadow-md">
    <div class="flex justify-between items-center mb-4">
        <div>
            <h2 class="text-xl font-bold text-gray-800">Create Order</h2>
            <p class="text-sm text-gray-600">Fill in the details below to book a new parcel for delivery.</p>
        </div>
    </div>

    <form action="{{ route('seller.orders.store') }}" method="POST">
        @csrf
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label for="order_type" class="block text-sm font-medium text-gray-700">Order Type</label>
                <select id="order_type" name="order_type" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                    <option>Normal</option>
                    <option>Express</option>
                </select>
            </div>
            <div>
                <label for="order_ref" class="block text-sm font-medium text-gray-700">Order Reference Number</label>
                <input type="text" name="order_ref" id="order_ref" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Order ref Number">
            </div>
            <div>
                <label for="cod_amount" class="block text-sm font-medium text-gray-700">Order Amount</label>
                <input type="number" name="cod_amount" id="cod_amount" value="0" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
            </div>
            <div>
                <label for="order_date" class="block text-sm font-medium text-gray-700">Order Date</label>
                <input type="date" name="order_date" id="order_date" value="{{ now()->format('Y-m-d') }}" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
            </div>
            <div>
                <label for="recipient_name" class="block text-sm font-medium text-gray-700">Customer Name</label>
                <input type="text" name="recipient_name" id="recipient_name" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Customer Name">
            </div>
            <div>
                <label for="recipient_phone" class="block text-sm font-medium text-gray-700">Customer Contact</label>
                <input type="text" name="recipient_phone" id="recipient_phone" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="03xxxxxxxxx">
            </div>
            <div>
                <label for="recipient_city" class="block text-sm font-medium text-gray-700">Delivery City</label>
                <select id="recipient_city" name="recipient_city" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                    <option>Anytown</option>
                    <option>Othertown</option>
                </select>
            </div>
            <div>
                <label for="recipient_address" class="block text-sm font-medium text-gray-700">Delivery Address</label>
                <input type="text" name="recipient_address" id="recipient_address" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Customer Address">
            </div>
        </div>

        <div class="mt-8 flex justify-end gap-3">
            <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded-md font-semibold hover:bg-green-700 transition">Save</button>
            <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-md font-semibold hover:bg-blue-700 transition">Save & Print</button>
            <a href="{{ route('seller.dashboard') }}" class="bg-red-600 text-white px-6 py-2 rounded-md font-semibold hover:bg-red-700 transition">Close</a>
        </div>
    </form>
</div>
@endsection
