@extends('layouts.seller')

@section('title', 'Edit Order')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-2xl font-semibold text-gray-800 mb-6">Edit Order #{{ $order->tracking_id }}</h1>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="{{ route('seller.orders.update', $order) }}" method="POST">
            @csrf
            @method('PUT')
            <!-- Recipient Information -->
            <div class="mb-6 pb-6 border-b">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Recipient Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="recipient_name" class="block text-sm font-medium text-gray-700 mb-1">Name</label>
                        <input type="text" id="recipient_name" name="recipient_name" value="{{ old('recipient_name', $order->recipient_name) }}" class="w-full border-gray-300 rounded-md shadow-sm" required>
                    </div>
                    <div>
                        <label for="recipient_phone" class="block text-sm font-medium text-gray-700 mb-1">Phone</label>
                        <input type="text" id="recipient_phone" name="recipient_phone" value="{{ old('recipient_phone', $order->recipient_phone) }}" class="w-full border-gray-300 rounded-md shadow-sm" required>
                    </div>
                    <div class="md:col-span-2">
                        <label for="recipient_address" class="block text-sm font-medium text-gray-700 mb-1">Address</label>
                        <input type="text" id="recipient_address" name="recipient_address" value="{{ old('recipient_address', $order->recipient_address) }}" class="w-full border-gray-300 rounded-md shadow-sm" required>
                    </div>
                    <div>
                        <label for="recipient_city" class="block text-sm font-medium text-gray-700 mb-1">City</label>
                        <input type="text" id="recipient_city" name="recipient_city" value="{{ old('recipient_city', $order->recipient_city) }}" class="w-full border-gray-300 rounded-md shadow-sm" required>
                    </div>
                </div>
            </div>

            <!-- Parcel Details -->
            <div>
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Parcel Details</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                     <div>
                        <label for="cod_amount" class="block text-sm font-medium text-gray-700 mb-1">Cash on Delivery (COD) Amount</label>
                        <input type="number" id="cod_amount" name="cod_amount" value="{{ old('cod_amount', $order->cod_amount) }}" class="w-full border-gray-300 rounded-md shadow-sm" placeholder="PKR 0.00" required>
                    </div>
                    <div>
                        <label for="parcel_weight" class="block text-sm font-medium text-gray-700 mb-1">Weight (kg)</label>
                        <input type="number" step="0.1" id="parcel_weight" name="parcel_weight" value="{{ old('parcel_weight', $order->parcel_weight) }}" class="w-full border-gray-300 rounded-md shadow-sm" placeholder="e.g., 1.5" required>
                    </div>
                    <div class="md:col-span-2">
                        <label for="parcel_details" class="block text-sm font-medium text-gray-700 mb-1">Parcel Content Details</label>
                        <textarea id="parcel_details" name="parcel_details" rows="3" class="w-full border-gray-300 rounded-md shadow-sm">{{ old('parcel_details', $order->parcel_details) }}</textarea>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="mt-8 pt-6 border-t flex justify-end gap-4">
                <a href="{{ route('seller.orders.index') }}" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-md font-semibold hover:bg-gray-300 transition">Cancel</a>
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-md font-semibold hover:bg-blue-700 transition">Update Order</button>
            </div>
        </form>
    </div>
</div>
@endsection
