@extends('layouts.seller')

@section('title', 'Cancel Order')

@section('content')
<div class="bg-white p-6 rounded-lg shadow-md">
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-xl font-bold text-gray-800">Cancel order</h2>
    </div>

    <div class="border-b border-gray-200">
        <nav class="-mb-px flex space-x-6">
            <a href="{{ route('seller.orders.index') }}" class="py-4 px-1 border-b-2 {{ request('tab') == '' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} font-medium text-sm">All ({{ $allCount }})</a>
            <a href="{{ route('seller.orders.index', ['tab' => 'booked']) }}" class="py-4 px-1 border-b-2 {{ request('tab') == 'booked' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} font-medium text-sm">Booked ({{ $bookedCount }})</a>
            <a href="{{ route('seller.orders.index', ['tab' => 'unbooked']) }}" class="py-4 px-1 border-b-2 {{ request('tab') == 'unbooked' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} font-medium text-sm">Unbooked ({{ $unbookedCount }})</a>
            <a href="{{ route('seller.orders.index', ['tab' => 'logs']) }}" class="py-4 px-1 border-b-2 {{ request('tab') == 'logs' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} font-medium text-sm">Logs ({{ $logsCount }})</a>
        </nav>
    </div>

    <div class="mt-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">ADVANCED SEARCH</h3>
        <form action="{{ route('seller.orders.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <input type="hidden" name="tab" value="{{ request('tab') }}">
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700">Search by</label>
                <input type="text" name="search" id="search" value="{{ request('search') }}" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm" placeholder="Order #, Customer...">
            </div>
            <div>
                <label for="from_date" class="block text-sm font-medium text-gray-700">From</label>
                <input type="date" name="from_date" id="from_date" value="{{ request('from_date') }}" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm">
            </div>
            <div>
                <label for="to_date" class="block text-sm font-medium text-gray-700">To</label>
                <input type="date" name="to_date" id="to_date" value="{{ request('to_date') }}" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm">
            </div>
            <div class="md:col-span-3 flex justify-start gap-2">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">Search</button>
                <a href="{{ route('seller.orders.index', ['tab' => request('tab')]) }}" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold">Clear Filter</a>
            </div>
        </form>
    </div>

    <div class="mt-8 overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead>
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order Ref #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tracking #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Delivery Address</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Action</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($orders as $order)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $order->order_ref ?? 'N/A' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-blue-600">{{ $order->tracking_id }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $order->recipient_name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $order->recipient_address }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">PKR {{ number_format($order->cod_amount, 2) }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">{{ $order->status }}</span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        @if($order->trashed())
                        <span class="text-gray-400">Cancelled</span>
                        @else
                        <form action="{{ route('seller.orders.destroy', $order) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:text-red-900">Cancel</button>
                        </form>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center py-10 text-sm text-gray-500">No orders available.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
        <div class="mt-4">
            {{ $orders->appends(request()->query())->links() }}
        </div>
    </div>
</div>
@endsection
