@extends('layouts.seller')

@section('title', 'Order Details')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-800">Order Details</h1>
        <a href="{{ route('seller.orders.index') }}" class="text-blue-600 hover:text-blue-800">&larr; Back to Orders</a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <h2 class="text-xl font-semibold text-gray-800">Order #{{ $order->tracking_id }}</h2>
                        <p class="text-sm text-gray-500">Placed on {{ $order->created_at->format('F d, Y') }}</p>
                    </div>
                    <span class="px-3 py-1 text-sm font-semibold rounded-full bg-blue-100 text-blue-800">{{ $order->status }}</span>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6 pt-6 border-t">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800 mb-2">Recipient</h3>
                        <p class="text-gray-700">{{ $order->recipient_name }}</p>
                        <p class="text-gray-700">{{ $order->recipient_address }}</p>
                        <p class="text-gray-700">{{ $order->recipient_phone }}</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800 mb-2">Order Summary</h3>
                        <dl class="space-y-2">
                            <div class="flex justify-between">
                                <dt class="text-gray-600">COD Amount:</dt>
                                <dd class="font-semibold">PKR {{ number_format($order->cod_amount, 2) }}</dd>
                            </div>
                            <div class="flex justify-between">
                                <dt class="text-gray-600">Shipping Fee:</dt>
                                <dd class="font-semibold">PKR 200.00</dd>
                            </div>
                            <div class="flex justify-between border-t pt-2">
                                <dt class="font-semibold">Total:</dt>
                                <dd class="font-bold">PKR 1,700.00</dd>
                            </div>
                        </dl>
                    </div>
                </div>
            </div>
        </div>

        <div>
            <div class="bg-white rounded-lg shadow-md p-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Order Timeline</h3>
                <ul class="space-y-4">
                    <li class="flex items-start">
                        <div class="w-6 h-6 bg-green-500 rounded-full flex items-center justify-center text-white"><i class="fas fa-check"></i></div>
                        <div class="ml-4">
                            <p class="font-semibold">Delivered</p>
                            <p class="text-sm text-gray-500">October 03, 2025</p>
                        </div>
                    </li>
                    <li class="flex items-start">
                        <div class="w-6 h-6 bg-blue-500 rounded-full"></div>
                        <div class="ml-4">
                            <p class="font-semibold">Out for Delivery</p>
                            <p class="text-sm text-gray-500">October 03, 2025</p>
                        </div>
                    </li>
                    <li class="flex items-start">
                        <div class="w-6 h-6 bg-blue-500 rounded-full"></div>
                        <div class="ml-4">
                            <p class="font-semibold">In Transit</p>
                            <p class="text-sm text-gray-500">October 02, 2025</p>
                        </div>
                    </li>
                    <li class="flex items-start">
                        <div class="w-6 h-6 bg-blue-500 rounded-full"></div>
                        <div class="ml-4">
                            <p class="font-semibold">Order Created</p>
                            <p class="text-sm text-gray-500">October 01, 2025</p>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection
