@extends('layouts.seller')

@section('title', 'Integrations')

@section('content')
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-6 flex items-center gap-4">
            <div class="text-green-500">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 81 91.5" class="h-8 w-8">
                    <path fill="currentColor" d="M62.6 48.9c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1s4.2-1.8 4.2-4.1c.1-2.4-1.8-4.2-4.2-4.2zm-44.2 0c-2.4 0-4.2 1.8-4.2 4.2.1-2.4-1.8-4.2-4.2-4.2zM81 23.4v60c0 4.5-3.6 8.1-8.1 8.1H8.1C3.6 91.5 0 87.9 0 83.4v-60c0-4.5 3.6-8.1 8.1-8.1h64.8c4.5 0 8.1 3.6 8.1 8.1zM62.6 28.5c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1s4.2-1.8 4.2-4.1c.1-2.3-1.8-4.2-4.2-4.2zm-44.2 0c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1 2.3 0 4.2-1.8 4.2-4.1.1-2.3-1.8-4.2-4.2-4.2zm44.2 41.2c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1s4.2-1.8 4.2-4.1c.1-2.4-1.8-4.2-4.2-4.2zm-44.2 0c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1 2.3 0 4.2-1.8 4.2-4.1.1-2.4-1.8-4.2-4.2-4.2zM62.6 8.7h-4.9c-2.7-5.1-8.1-8.7-14.2-8.7-6.1 0-11.5 3.5-14.2 8.7h-4.9c-2.6 0-4.8 2.2-4.8 4.8s2.2 4.8 4.8 4.8h4.9c.7 0 1.3-.2 1.9-.4 2.8-5.3 8.3-9 14.7-9s11.9 3.7 14.7 9c.6.2 1.2.4 1.9.4h4.9c2.6 0 4.8-2.2 4.8-4.8s-2.2-4.8-4.8-4.8z"/>
                </svg>
            </div>
            <div>
                <h3 class="text-lg font-bold">Shopify</h3>
                <p class="text-sm text-gray-600">Connect your Shopify store to automatically import orders.</p>
            </div>
        </div>
        <div class="p-6 bg-gray-50 border-t">
            <button class="w-full bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">Connect</button>
        </div>
    </div>
    <div class="bg-white rounded-lg shadow-md border-dashed border-2">
        <div class="p-6">
            <h3 class="text-lg font-bold">More coming soon</h3>
            <p class="text-sm text-gray-600">Integrations with other platforms are on the way.</p>
        </div>
        <div class="p-6 bg-gray-50 border-t">
            <button class="w-full bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold" disabled>Coming Soon</button>
        </div>
    </div>
</div>
@endsection
