@extends('layouts.seller')

@section('title', 'Book New Parcel')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Book a New Parcel</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Enter shipment details to create a new booking.</p>
    </div>

    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 sm:p-6 border-b">
            <h2 class="text-lg font-semibold">Shipment Details</h2>
        </div>
        <form action="#" method="POST" class="p-4 sm:p-6">
            @csrf
            <!-- Sender Information -->
            <div class="mb-6 pb-6 border-b">
                <h3 class="text-base font-semibold text-gray-800 mb-4">Sender Information</h3>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label for="sender_name" class="block text-sm font-medium text-gray-700 mb-1">Name</label>
                        <input type="text" id="sender_name" name="sender_name" value="{{ auth()->user()->name }}" class="w-full border-gray-300 rounded-md shadow-sm" readonly>
                    </div>
                    <div>
                        <label for="sender_phone" class="block text-sm font-medium text-gray-700 mb-1">Phone</label>
                        <input type="text" id="sender_phone" name="sender_phone" value="{{ auth()->user()->phone }}" class="w-full border-gray-300 rounded-md shadow-sm" readonly>
                    </div>
                    <div class="sm:col-span-2">
                        <label for="sender_address" class="block text-sm font-medium text-gray-700 mb-1">Address</label>
                        <input type="text" id="sender_address" name="sender_address" value="{{ auth()->user()->address }}" class="w-full border-gray-300 rounded-md shadow-sm" readonly>
                    </div>
                </div>
            </div>

            <!-- Recipient Information -->
            <div class="mb-6 pb-6 border-b">
                <h3 class="text-base font-semibold text-gray-800 mb-4">Recipient Information</h3>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label for="recipient_name" class="block text-sm font-medium text-gray-700 mb-1">Name</label>
                        <input type="text" id="recipient_name" name="recipient_name" class="w-full border-gray-300 rounded-md shadow-sm" required>
                    </div>
                    <div>
                        <label for="recipient_phone" class="block text-sm font-medium text-gray-700 mb-1">Phone</label>
                        <input type="text" id="recipient_phone" name="recipient_phone" class="w-full border-gray-300 rounded-md shadow-sm" required>
                    </div>
                    <div class="sm:col-span-2">
                        <label for="recipient_address" class="block text-sm font-medium text-gray-700 mb-1">Address</label>
                        <input type="text" id="recipient_address" name="recipient_address" class="w-full border-gray-300 rounded-md shadow-sm" required>
                    </div>
                    <div>
                        <label for="recipient_city" class="block text-sm font-medium text-gray-700 mb-1">City</label>
                        <input type="text" id="recipient_city" name="recipient_city" class="w-full border-gray-300 rounded-md shadow-sm" required>
                    </div>
                </div>
            </div>

            <!-- Parcel Details -->
            <div>
                <h3 class="text-base font-semibold text-gray-800 mb-4">Parcel Details</h3>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                     <div>
                        <label for="cod_amount" class="block text-sm font-medium text-gray-700 mb-1">Cash on Delivery (COD) Amount</label>
                        <input type="number" id="cod_amount" name="cod_amount" class="w-full border-gray-300 rounded-md shadow-sm" placeholder="PKR 0.00" required>
                    </div>
                    <div>
                        <label for="parcel_weight" class="block text-sm font-medium text-gray-700 mb-1">Weight (kg)</label>
                        <input type="number" step="0.1" id="parcel_weight" name="parcel_weight" class="w-full border-gray-300 rounded-md shadow-sm" placeholder="e.g., 1.5" required>
                    </div>
                    <div class="sm:col-span-2">
                        <label for="parcel_details" class="block text-sm font-medium text-gray-700 mb-1">Parcel Content Details</label>
                        <textarea id="parcel_details" name="parcel_details" rows="3" class="w-full border-gray-300 rounded-md shadow-sm"></textarea>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="mt-6 pt-6 border-t flex justify-end gap-3">
                <button type="button" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md text-sm font-semibold hover:bg-gray-300 transition">Cancel</button>
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">Book Parcel</button>
            </div>
        </form>
    </div>
</div>
@endsection
