@extends('layouts.seller')

@section('title', 'My Parcels')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between mb-4 sm:mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">My Parcels</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">View and manage all your shipments.</p>
        </div>
        <div class="mt-3 sm:mt-0">
            <a href="{{ route('seller.parcels.create') }}" class="w-full sm:w-auto bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition flex items-center justify-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                Book New Parcel
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 mb-4 sm:mb-6">
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 items-end">
            <div>
                <label for="search" class="block text-[11px] font-medium text-gray-700 mb-1">Search</label>
                <input type="text" id="search" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Tracking ID, Recipient...">
            </div>
            <div>
                <label for="status" class="block text-[11px] font-medium text-gray-700 mb-1">Status</label>
                <select id="status" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Statuses</option>
                    <option value="Pending">Pending</option>
                    <option value="In Transit">In Transit</option>
                    <option value="Delivered">Delivered</option>
                    <option value="Cancelled">Cancelled</option>
                </select>
            </div>
            <div>
                <label for="date_range" class="block text-[11px] font-medium text-gray-700 mb-1">Date Range</label>
                <input type="date" id="date_range" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            <div>
                <button class="w-full bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-gray-800 transition">Apply Filters</button>
            </div>
        </div>
    </div>

    <!-- Parcels Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Tracking ID</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Recipient</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    {{-- @forelse($parcels as $parcel) --}}
                    @for ($i = 0; $i < 5; $i++)
                    <tr>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-blue-600">
                            <a href="#">AW{{ rand(100000000, 999999999) }}</a>
                        </td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">John Doe</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ now()->subDays($i)->format('d M, Y') }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">PKR {{ number_format(rand(500, 5000), 2) }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap">
                            <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-green-100 text-green-800">
                                Delivered
                            </span>
                        </td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-right text-xs font-medium">
                            <a href="#" class="text-blue-600 hover:text-blue-900">View</a>
                        </td>
                    </tr>
                    @endfor
                    {{-- @empty --}}
                    {{-- <tr>
                        <td colspan="6" class="px-4 py-10 text-center text-sm text-gray-500">No parcels found matching your criteria.</td>
                    </tr> --}}
                    {{-- @endforelse --}}
                </tbody>
            </table>
        </div>
        <!-- Pagination -->
        <div class="px-4 py-3 border-t">
            <p class="text-xs text-gray-600">Pagination placeholder</p>
        </div>
    </div>
</div>
@endsection
