@extends('layouts.seller')

@section('title', 'Track Shipment')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Track a Shipment</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Enter a tracking ID to see the latest shipment status.</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <div class="max-w-md mx-auto">
            <div class="flex items-center gap-2">
                <input type="text" id="tracking_id" name="tracking_id" class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter Tracking ID (e.g., AW123456789)">
                <button id="trackBtn" class="bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">
                    Track
                </button>
            </div>

            <div id="tracking-results" class="mt-6 border-t pt-6 hidden">
                <!-- Tracking results will be loaded here via JS -->
                <p class="text-center text-gray-500">Loading tracking details...</p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.getElementById('trackBtn').addEventListener('click', function() {
        const trackingId = document.getElementById('tracking_id').value;
        const resultsContainer = document.getElementById('tracking-results');

        if (!trackingId) {
            alert('Please enter a tracking ID.');
            return;
        }

        resultsContainer.classList.remove('hidden');
        resultsContainer.innerHTML = `<p class="text-center text-gray-500">Searching for tracking ID: <strong>${trackingId}</strong>...</p>`;

        // Simulate API call
        setTimeout(() => {
            // Replace with actual fetch to your tracking endpoint
            const mockStatus = {
                'AW123456789': 'In Transit',
                'AW987654321': 'Delivered',
            };
            const status = mockStatus[trackingId] || 'Not Found';

            let statusColor = 'text-gray-800';
            if (status === 'In Transit') statusColor = 'text-blue-800';
            if (status === 'Delivered') statusColor = 'text-green-800';
            if (status === 'Not Found') statusColor = 'text-red-800';

            resultsContainer.innerHTML = `
                <div class="text-center">
                    <p class="text-sm text-gray-600">Status for ${trackingId}</p>
                    <p class="text-2xl font-bold ${statusColor}">${status}</p>
                </div>
                <div class="mt-4 border-t pt-4 text-sm text-gray-600 space-y-2">
                    <p><strong>Location:</strong> Warehouse, City</p>
                    <p><strong>Last Updated:</strong> ${new Date().toLocaleString()}</p>
                </div>
            `;
        }, 1500);
    });
</script>
@endpush
