@extends('layouts.seller')

@section('title', 'Edit Profile')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">My Profile</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Update your personal and company information.</p>
    </div>

    <div class="bg-white rounded-lg shadow-md max-w-3xl mx-auto">
        <form action="#" method="POST" class="p-4 sm:p-6">
            @csrf
            @method('PATCH')

            <!-- Personal Information -->
            <div class="mb-6 pb-6 border-b">
                <h3 class="text-base font-semibold text-gray-800 mb-4">Personal Information</h3>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Full Name</label>
                        <input type="text" id="name" name="name" value="{{ auth()->user()->name }}" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                        <input type="email" id="email" name="email" value="{{ auth()->user()->email }}" class="w-full border-gray-300 rounded-md shadow-sm bg-gray-100" readonly>
                    </div>
                    <div>
                        <label for="phone" class="block text-sm font-medium text-gray-700 mb-1">Phone Number</label>
                        <input type="text" id="phone" name="phone" value="{{ auth()->user()->phone }}" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                </div>
            </div>

            <!-- Company Information -->
            <div class="mb-6 pb-6 border-b">
                <h3 class="text-base font-semibold text-gray-800 mb-4">Company Information</h3>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label for="company_name" class="block text-sm font-medium text-gray-700 mb-1">Company Name</label>
                        <input type="text" id="company_name" name="company_name" value="{{ auth()->user()->company_name }}" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                    <div class="sm:col-span-2">
                        <label for="address" class="block text-sm font-medium text-gray-700 mb-1">Address</label>
                        <input type="text" id="address" name="address" value="{{ auth()->user()->address }}" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                </div>
            </div>

            <!-- Change Password -->
            <div>
                <h3 class="text-base font-semibold text-gray-800 mb-4">Change Password</h3>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label for="current_password" class="block text-sm font-medium text-gray-700 mb-1">Current Password</label>
                        <input type="password" id="current_password" name="current_password" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                    <div>
                        <label for="new_password" class="block text-sm font-medium text-gray-700 mb-1">New Password</label>
                        <input type="password" id="new_password" name="new_password" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="mt-6 pt-6 border-t flex justify-end">
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">Save Changes</button>
            </div>
        </form>
    </div>
</div>
@endsection
