@extends('layouts.seller')

@section('title', 'Amount-wise Report')

@section('content')
<div class="grid gap-8 lg:grid-cols-2">
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h2 class="text-xl font-bold text-gray-800">Weekly Order Amount (PKR)</h2>
        <p class="text-sm text-gray-600 mb-4">Total COD amount from orders per week.</p>
        <div class="h-80">
            <canvas id="weeklyAmountChart"></canvas>
        </div>
    </div>
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h2 class="text-xl font-bold text-gray-800">Monthly Order Amount (PKR)</h2>
        <p class="text-sm text-gray-600 mb-4">Total COD amount from orders per month.</p>
        <div class="h-80">
            <canvas id="monthlyAmountChart"></canvas>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const weeklyData = {
            labels: {!! json_encode($weeklyAmounts->pluck('date')) !!},
            datasets: [{
                label: 'Amount (PKR)',
                data: {!! json_encode($weeklyAmounts->pluck('amount')) !!},
                backgroundColor: 'rgba(54, 162, 235, 0.5)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        };

        const monthlyData = {
            labels: {!! json_encode($monthlyAmounts->map(function($item) { return date('M Y', mktime(0, 0, 0, $item->month, 1, $item->year)); })) !!},
            datasets: [{
                label: 'Amount (PKR)',
                data: {!! json_encode($monthlyAmounts->pluck('amount')) !!},
                backgroundColor: 'rgba(255, 99, 132, 0.5)',
                borderColor: 'rgba(255, 99, 132, 1)',
                borderWidth: 1
            }]
        };

        const weeklyCtx = document.getElementById('weeklyAmountChart').getContext('2d');
        new Chart(weeklyCtx, {
            type: 'bar',
            data: weeklyData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        const monthlyCtx = document.getElementById('monthlyAmountChart').getContext('2d');
        new Chart(monthlyCtx, {
            type: 'bar',
            data: monthlyData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    });
</script>
@endpush
