@extends('layouts.seller')

@section('title', 'Financial Reports')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Financial Reports</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Generate and download reports on your financial activity.</p>
    </div>

    <!-- Report Generation Form -->
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mb-4 sm:mb-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Generate New Report</h2>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 items-end">
            <div>
                <label for="report_type" class="block text-[11px] font-medium text-gray-700 mb-1">Report Type</label>
                <select id="report_type" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option>Payout Summary</option>
                    <option>Transaction History</option>
                    <option>COD Reconciliation</option>
                    <option>Invoice Summary</option>
                </select>
            </div>
            <div>
                <label for="start_date" class="block text-[11px] font-medium text-gray-700 mb-1">Start Date</label>
                <input type="date" id="start_date" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            <div>
                <label for="end_date" class="block text-[11px] font-medium text-gray-700 mb-1">End Date</label>
                <input type="date" id="end_date" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            <div>
                <button class="w-full bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">Generate Report</button>
            </div>
        </div>
    </div>

    <!-- Generated Reports Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
         <div class="p-4 sm:p-6 border-b">
            <h2 class="text-lg font-semibold">Generated Reports</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Report Name</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date Range</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Generated On</th>
                        <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @for ($i = 0; $i < 3; $i++)
                    <tr>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900">Payout Summary</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ now()->subMonths($i+1)->startOfMonth()->format('d M') }} - {{ now()->subMonths($i+1)->endOfMonth()->format('d M, Y') }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ now()->subDays($i*3)->format('d M, Y h:i A') }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-right text-xs font-medium">
                            <a href="#" class="text-blue-600 hover:text-blue-900">Download</a>
                        </td>
                    </tr>
                    @endfor
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
