<!DOCTYPE html>
<html>
<head>
    <title>Order Report</title>
    <style>
        body { font-family: sans-serif; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h1>Order Report</h1>
    <table>
        <thead>
            <tr>
                <th>Order ID</th>
                <th>Recipient</th>
                <th>COD Amount</th>
                <th>Status</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach($orders as $order)
            <tr>
                <td>{{ $order->tracking_id }}</td>
                <td>{{ $order->recipient_name }}</td>
                <td>{{ number_format($order->cod_amount, 2) }}</td>
                <td>{{ $order->status }}</td>
                <td>{{ $order->created_at->format('d M, Y') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
