@extends('layouts.seller')

@section('title', 'Order Status Report')
@section('content')
<div class="bg-white p-6 rounded-lg shadow-md">
    <div class="flex flex-wrap items-center justify-between gap-4 mb-4">
        <div class="border-b border-gray-200">
            <nav class="-mb-px flex space-x-6">
                <a href="{{ route('seller.reports.status') }}" class="py-4 px-1 border-b-2 {{ request('tab') == '' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} font-medium text-sm">All ({{ $allCount }})</a>
                <a href="{{ route('seller.reports.status', ['tab' => 'Booked']) }}" class="py-4 px-1 border-b-2 {{ request('tab') == 'Booked' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} font-medium text-sm">Booked ({{ $bookedCount }})</a>
                <a href="{{ route('seller.reports.status', ['tab' => 'Pending']) }}" class="py-4 px-1 border-b-2 {{ request('tab') == 'Pending' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} font-medium text-sm">Unbooked ({{ $unbookedCount }})</a>
                <a href="{{ route('seller.reports.status', ['tab' => 'In Transit']) }}" class="py-4 px-1 border-b-2 {{ request('tab') == 'In Transit' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} font-medium text-sm">InTransit ({{ $inTransitCount }})</a>
            </nav>
        </div>
        <div class="flex items-center gap-2">
            <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-sync-alt"></i></button>
            <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-download"></i></button>
            <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-print"></i></button>
            <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-cog"></i></button>
        </div>
    </div>

    <div class="p-4 border rounded-lg bg-gray-50 mb-6">
        <p class="text-sm font-semibold mb-4">ADVANCED SEARCH</p>
        <form action="{{ route('seller.reports.status') }}" method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 items-end">
            <input type="hidden" name="tab" value="{{ request('tab') }}">
            <div class="lg:col-span-2">
                <label class="text-xs text-gray-500">Search by</label>
                <div class="flex">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search..." class="w-full border-gray-300 rounded-l-md shadow-sm">
                    <select name="search_type" class="w-auto min-w-[160px] border-gray-300 rounded-r-md shadow-sm border-l-0">
                        <option value="tracking_id" @selected(request('search_type') == 'tracking_id')>TRACKING #</option>
                        <option value="recipient_name" @selected(request('search_type') == 'recipient_name')>NAME</option>
                    </select>
                </div>
            </div>
            <div>
                <label class="text-xs text-gray-500">FROM</label>
                <input type="date" name="from_date" value="{{ request('from_date') }}" class="w-full border-gray-300 rounded-md shadow-sm">
            </div>
            <div>
                <label class="text-xs text-gray-500">TO</label>
                <input type="date" name="to_date" value="{{ request('to_date') }}" class="w-full border-gray-300 rounded-md shadow-sm">
            </div>
            <div class="flex items-end gap-2 col-start-1">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">Search</button>
                <a href="{{ route('seller.reports.status', ['tab' => request('tab')]) }}" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold text-center">Clear Filter</a>
            </div>
        </form>
    </div>

    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead>
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order Ref</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tracking #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($orders as $order)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $order->order_ref ?? 'N/A' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-blue-600">{{ $order->tracking_id }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $order->recipient_name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 text-right">PKR {{ number_format($order->cod_amount, 2) }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">{{ $order->status }}</span>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center py-10 text-sm text-gray-500">No data to display.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
        <div class="mt-4">
            {{ $orders->appends(request()->query())->links() }}
        </div>
    </div>
</div>
@endsection
