@extends('layouts.seller')

@section('title', 'Settings')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Settings</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage your notification preferences and account settings.</p>
    </div>

    <div class="bg-white rounded-lg shadow-md max-w-2xl mx-auto">
        <form action="#" method="POST" class="p-4 sm:p-6">
            @csrf
            
            <!-- Notification Settings -->
            <div class="mb-6 pb-6 border-b">
                <h3 class="text-base font-semibold text-gray-800 mb-4">Notification Preferences</h3>
                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="font-medium text-gray-800">Email Notifications</p>
                            <p class="text-sm text-gray-600">Receive updates about your shipments and account via email.</p>
                        </div>
                        <label for="email_notifications" class="flex items-center cursor-pointer">
                            <div class="relative">
                                <input type="checkbox" id="email_notifications" class="sr-only" checked>
                                <div class="block bg-gray-600 w-14 h-8 rounded-full"></div>
                                <div class="dot absolute left-1 top-1 bg-white w-6 h-6 rounded-full transition"></div>
                            </div>
                        </label>
                    </div>
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="font-medium text-gray-800">SMS Notifications</p>
                            <p class="text-sm text-gray-600">Receive critical alerts via SMS.</p>
                        </div>
                        <label for="sms_notifications" class="flex items-center cursor-pointer">
                            <div class="relative">
                                <input type="checkbox" id="sms_notifications" class="sr-only">
                                <div class="block bg-gray-600 w-14 h-8 rounded-full"></div>
                                <div class="dot absolute left-1 top-1 bg-white w-6 h-6 rounded-full transition"></div>
                            </div>
                        </label>
                    </div>
                </div>
            </div>

            <!-- API Settings -->
            <div>
                <h3 class="text-base font-semibold text-gray-800 mb-4">API Access</h3>
                <div class="flex items-center justify-between">
                    <div>
                        <p class="font-medium text-gray-800">Your API Key</p>
                        <p class="text-sm text-gray-600 font-mono bg-gray-100 px-2 py-1 rounded">**************abcd</p>
                    </div>
                    <button type="button" class="bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-gray-800 transition">Regenerate Key</button>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="mt-6 pt-6 border-t flex justify-end">
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">Save Settings</button>
            </div>
        </form>
    </div>
</div>
<style>
    input:checked ~ .dot {
        transform: translateX(100%);
        background-color: #4A90E2;
    }
    input:checked ~ .block {
        background-color: #C7D2FE;
    }
</style>
@endsection
