@extends('layouts.seller')

@section('title', 'Track Shipment')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Track a Shipment</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Enter a tracking ID to see the latest shipment status.</p>
    </div>

    @if(session('error'))
        <div class="mb-4 bg-red-50 text-red-700 border border-red-200 rounded-md px-3 py-2 text-sm">
            {{ session('error') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <form action="{{ route('parcels.track') }}" method="POST" class="max-w-md mx-auto">
            @csrf
            <label for="tracking_id" class="block text-[11px] font-medium text-gray-700 mb-1">Tracking ID</label>
            <div class="flex items-center gap-2">
                <input type="text" id="tracking_id" name="tracking_id" value="{{ old('tracking_id') }}" class="w-full border border-gray-300 rounded-md px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="e.g., PCL123456">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">
                    Track
                </button>
            </div>
            @error('tracking_id')
                <p class="text-xs text-red-600 mt-2">{{ $message }}</p>
            @enderror
            <p class="text-xs text-gray-500 mt-2">You can also view all shipments on the "All Shipments" page.</p>
        </form>
    </div>
</div>
@endsection