@extends('layouts.seller')

@section('title', 'Transactions')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Transactions</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">A complete history of your account transactions.</p>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 mb-4 sm:mb-6">
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 items-end">
            <div>
                <label for="search" class="block text-[11px] font-medium text-gray-700 mb-1">Search</label>
                <input type="text" id="search" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Description, Amount...">
            </div>
            <div>
                <label for="type" class="block text-[11px] font-medium text-gray-700 mb-1">Type</label>
                <select id="type" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Types</option>
                    <option value="Credit">Credit</option>
                    <option value="Debit">Debit</option>
                </select>
            </div>
            <div>
                <label for="date_range" class="block text-[11px] font-medium text-gray-700 mb-1">Date Range</label>
                <input type="date" id="date_range" class="w-full border border-gray-300 rounded-md px-3 py-1.5 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            <div>
                <button class="w-full bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-gray-800 transition">Apply Filters</button>
            </div>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Balance</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @php $balance = 33730; @endphp
                    @for ($i = 0; $i < 10; $i++)
                    @php 
                        $isCredit = rand(0, 1);
                        $amount = rand(500, 5000);
                        $balance += ($isCredit ? $amount : -$amount);
                    @endphp
                    <tr>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ now()->subDays($i)->format('d M, Y') }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $isCredit ? 'COD for parcel #AW'.rand(100000000, 999999999) : 'Shipping Fee' }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right font-medium {{ $isCredit ? 'text-green-600' : 'text-red-600' }}">
                            {{ $isCredit ? '+' : '-' }} PKR {{ number_format($amount, 2) }}
                        </td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right text-gray-500">{{ $isCredit ? 'Credit' : 'Debit' }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right text-gray-800">PKR {{ number_format($balance, 2) }}</td>
                    </tr>
                    @endfor
                </tbody>
            </table>
        </div>
        <!-- Pagination -->
        <div class="px-4 py-3 border-t">
            <p class="text-xs text-gray-600">Pagination placeholder</p>
        </div>
    </div>
</div>
@endsection
