@extends('layouts.seller')

@section('title', 'My Wallet')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">My Wallet</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage your balance and view transactions.</p>
    </div>

    <!-- Wallet Summary -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6 mb-4 sm:mb-6">
        <!-- Current Balance -->
        <div class="lg:col-span-2 bg-white rounded-lg shadow-md p-4 sm:p-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">Balance Details</h2>
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <p class="text-sm text-gray-600">Available for Payout</p>
                    <p class="text-2xl sm:text-3xl font-bold text-green-600">PKR 25,480.00</p>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Pending Clearance</p>
                    <p class="text-2xl sm:text-3xl font-bold text-yellow-600">PKR 8,250.00</p>
                </div>
                <div class="col-span-2 border-t pt-4">
                    <p class="text-sm text-gray-600">Total Balance</p>
                    <p class="text-2xl sm:text-3xl font-bold text-gray-900">PKR 33,730.00</p>
                </div>
            </div>
        </div>

        <!-- Payout Request -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">Request Payout</h2>
            <p class="text-sm text-gray-600 mb-4">Request a transfer of your available balance to your bank account.</p>
            <button class="w-full bg-blue-600 text-white px-4 py-2.5 rounded-md text-sm font-semibold hover:bg-blue-700 transition">Request Payout</button>
            <p class="text-xs text-gray-500 mt-2 text-center">Next payout date: {{ now()->addDays(3)->format('D, M j') }}</p>
        </div>
    </div>

    <!-- Recent Transactions -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="p-4 sm:p-6 border-b">
            <h2 class="text-lg font-semibold">Recent Transactions</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Type</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @for ($i = 0; $i < 5; $i++)
                    <tr>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ now()->subDays($i)->format('d M, Y') }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">COD for parcel #AW{{ rand(100000000, 999999999) }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right font-medium text-green-600">+ PKR {{ number_format(rand(500, 5000), 2) }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right text-gray-500">Credit</td>
                    </tr>
                     @endfor
                     <tr>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ now()->subDays(6)->format('d M, Y') }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">Payout to Bank Account</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right font-medium text-red-600">- PKR 15,000.00</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right text-gray-500">Debit</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
