<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin;

/**
 * Extended Admin Routes - Complete Enterprise System
 * All 200+ routes for full functionality
 */

// FINANCE, TAX & ACCOUNTING - Extended Routes
Route::prefix('finance')->name('finance.')->group(function () {
    
    // Cash & COD Management
    Route::prefix('cod')->name('cod.')->group(function () {
        Route::get('/daily-collection', [Admin\Finance\CODController::class, 'dailyCollection'])->name('daily-collection');
        Route::get('/deposits', [Admin\Finance\CODController::class, 'deposits'])->name('deposits');
        Route::post('/deposits', [Admin\Finance\CODController::class, 'storeDeposit'])->name('deposits.store');
        Route::get('/pending-report', [Admin\Finance\CODController::class, 'pendingReport'])->name('pending-report');
        Route::get('/variance-report', [Admin\Finance\CODController::class, 'varianceReport'])->name('variance-report');
    });
    
    // Merchant Settlements - MOVED TO web.php with proper controllers
    // Now using Settlement\InvoiceController, Settlement\PaymentController, etc.
    
    // Company Accounting
    Route::prefix('accounting')->name('accounting.')->group(function () {
        Route::get('/chart-of-accounts', [Admin\Finance\Accounting\AccountingController::class, 'chartOfAccounts'])->name('chart-of-accounts');
        Route::post('/chart-of-accounts', [Admin\Finance\Accounting\AccountingController::class, 'storeAccount'])->name('chart-of-accounts.store');
        Route::get('/journal-entries', [Admin\Finance\Accounting\AccountingController::class, 'journalEntries'])->name('journal-entries');
        Route::post('/journal-entries', [Admin\Finance\Accounting\AccountingController::class, 'storeJournalEntry'])->name('journal-entries.store');
        Route::get('/ledger', [Admin\Finance\Accounting\AccountingController::class, 'ledger'])->name('ledger');
        Route::get('/trial-balance', [Admin\Finance\Accounting\AccountingController::class, 'trialBalance'])->name('trial-balance');
        Route::get('/balance-sheet', [Admin\Finance\Accounting\AccountingController::class, 'balanceSheet'])->name('balance-sheet');
        Route::get('/profit-loss', [Admin\Finance\Accounting\AccountingController::class, 'profitLoss'])->name('profit-loss');
    });
    
    // Expenses & Payments
    Route::prefix('expenses')->name('expenses.')->group(function () {
        Route::get('/', [Admin\Finance\Expense\ExpenseController::class, 'index'])->name('index');
        Route::get('/company', [Admin\Finance\Expense\ExpenseController::class, 'companyExpenses'])->name('company');
        Route::get('/branch', [Admin\Finance\Expense\ExpenseController::class, 'branchExpenses'])->name('branch');
        Route::get('/vendor-payments', [Admin\Finance\Expense\ExpenseController::class, 'vendorPayments'])->name('vendor-payments');
        Route::get('/approval-flow', [Admin\Finance\Expense\ExpenseController::class, 'approvalFlow'])->name('approval-flow');
        Route::get('/recurring', [Admin\Finance\Expense\ExpenseController::class, 'recurring'])->name('recurring');
        Route::post('/', [Admin\Finance\Expense\ExpenseController::class, 'store'])->name('store');
        Route::put('/{expense}/approve', [Admin\Finance\Expense\ExpenseController::class, 'approve'])->name('approve');
    });
    
    // Payroll & Salaries
    Route::prefix('payroll')->name('payroll.')->group(function () {
        Route::get('/employee-master', [Admin\Finance\Payroll\PayrollController::class, 'employeeMaster'])->name('employee-master');
        Route::get('/attendance', [Admin\Finance\Payroll\PayrollController::class, 'attendance'])->name('attendance');
        Route::get('/run', [Admin\Finance\Payroll\PayrollController::class, 'run'])->name('run');
        Route::post('/run', [Admin\Finance\Payroll\PayrollController::class, 'processPayroll'])->name('run.process');
        Route::get('/tax-deductions', [Admin\Finance\Payroll\PayrollController::class, 'taxDeductions'])->name('tax-deductions');
        Route::get('/salary-slips', [Admin\Finance\Payroll\PayrollController::class, 'salarySlips'])->name('salary-slips');
        Route::get('/bonus', [Admin\Finance\Payroll\PayrollController::class, 'bonus'])->name('bonus');
        Route::post('/bonus', [Admin\Finance\Payroll\PayrollController::class, 'storeBonus'])->name('bonus.store');
    });
    
    // Taxation
    Route::prefix('taxation')->name('taxation.')->group(function () {
        Route::get('/gst-calculation', [Admin\Finance\Taxation\TaxationController::class, 'gstCalculation'])->name('gst-calculation');
        Route::get('/income-tax', [Admin\Finance\Taxation\TaxationController::class, 'incomeTax'])->name('income-tax');
        Route::get('/filings', [Admin\Finance\Taxation\TaxationController::class, 'filings'])->name('filings');
        Route::post('/filings', [Admin\Finance\Taxation\TaxationController::class, 'submitFiling'])->name('filings.submit');
        Route::get('/e-filing', [Admin\Finance\Taxation\TaxationController::class, 'eFiling'])->name('e-filing');
        Route::get('/deduction-reports', [Admin\Finance\Taxation\TaxationController::class, 'deductionReports'])->name('deduction-reports');
        Route::get('/calendar-alerts', [Admin\Finance\Taxation\TaxationController::class, 'calendarAlerts'])->name('calendar-alerts');
    });
    
    // Banking & Reconciliation
    Route::prefix('banking')->name('banking.')->group(function () {
        Route::get('/accounts', [Admin\Finance\Banking\BankingController::class, 'accounts'])->name('accounts');
        Route::post('/accounts', [Admin\Finance\Banking\BankingController::class, 'linkAccount'])->name('accounts.link');
        Route::get('/reconciliation', [Admin\Finance\Banking\BankingController::class, 'reconciliation'])->name('reconciliation');
        Route::post('/reconciliation', [Admin\Finance\Banking\BankingController::class, 'reconcile'])->name('reconciliation.process');
        Route::get('/cheques', [Admin\Finance\Banking\BankingController::class, 'cheques'])->name('cheques');
        Route::get('/discrepancies', [Admin\Finance\Banking\BankingController::class, 'discrepancies'])->name('discrepancies');
    });
    
    // Vouchers
    Route::prefix('vouchers')->name('vouchers.')->group(function () {
        Route::get('/cash-payment', [Admin\Finance\Voucher\VoucherController::class, 'cashPayment'])->name('cash-payment');
        Route::get('/bank-payment', [Admin\Finance\Voucher\VoucherController::class, 'bankPayment'])->name('bank-payment');
        Route::get('/cash-receipt', [Admin\Finance\Voucher\VoucherController::class, 'cashReceipt'])->name('cash-receipt');
        Route::get('/bank-receipt', [Admin\Finance\Voucher\VoucherController::class, 'bankReceipt'])->name('bank-receipt');
        Route::get('/journal', [Admin\Finance\Voucher\VoucherController::class, 'journal'])->name('journal');
        Route::get('/contra', [Admin\Finance\Voucher\VoucherController::class, 'contra'])->name('contra');
        Route::post('/', [Admin\Finance\Voucher\VoucherController::class, 'store'])->name('store');
    });
});

// MARKETING & SALES - Extended Routes
Route::prefix('marketing')->name('marketing.')->group(function () {
    Route::get('/profiles', [Admin\Marketing\Profile\ProfileController::class, 'index'])->name('profiles');
    Route::get('/hierarchy', [Admin\Marketing\Profile\ProfileController::class, 'hierarchy'])->name('hierarchy');
    Route::get('/wallet-status', [Admin\Marketing\Profile\ProfileController::class, 'walletStatus'])->name('wallet-status');
    Route::get('/shipment-summary', [Admin\Marketing\Profile\ProfileController::class, 'shipmentSummary'])->name('shipment-summary');
    
    Route::get('/special-rates', [Admin\Marketing\Rate\RateController::class, 'specialRates'])->name('special-rates');
    Route::get('/documents', [Admin\Marketing\Rate\RateController::class, 'documents'])->name('documents');
    
    Route::get('/communication-log', [Admin\Marketing\Tool\ToolController::class, 'communicationLog'])->name('communication-log');
    Route::get('/communication-log/create', [Admin\Marketing\Tool\ToolController::class, 'createCommunicationLog'])->name('communication-log.create');
    Route::post('/communication-log', [Admin\Marketing\Tool\ToolController::class, 'storeCommunicationLog'])->name('communication-log.store');
    Route::get('/communication-log/{log}/edit', [Admin\Marketing\Tool\ToolController::class, 'editCommunicationLog'])->name('communication-log.edit');
    Route::put('/communication-log/{log}', [Admin\Marketing\Tool\ToolController::class, 'updateCommunicationLog'])->name('communication-log.update');
    Route::delete('/communication-log/{log}', [Admin\Marketing\Tool\ToolController::class, 'destroyCommunicationLog'])->name('communication-log.destroy');
    Route::get('/task-manager', [Admin\Marketing\Tool\ToolController::class, 'taskManager'])->name('task-manager');
    Route::get('/task-manager/create', [Admin\Marketing\Tool\ToolController::class, 'createTask'])->name('task-manager.create');
    Route::post('/task-manager', [Admin\Marketing\Tool\ToolController::class, 'storeTask'])->name('task-manager.store');
    Route::get('/task-manager/{task}/edit', [Admin\Marketing\Tool\ToolController::class, 'editTask'])->name('task-manager.edit');
    Route::put('/task-manager/{task}', [Admin\Marketing\Tool\ToolController::class, 'updateTask'])->name('task-manager.update');
    Route::delete('/task-manager/{task}', [Admin\Marketing\Tool\ToolController::class, 'destroyTask'])->name('task-manager.destroy');
    Route::get('/sentiment-tracking', [Admin\Marketing\Tool\ToolController::class, 'sentimentTracking'])->name('sentiment-tracking');
    Route::get('/sentiment-tracking/create', [Admin\Marketing\Tool\ToolController::class, 'createSentiment'])->name('sentiment-tracking.create');
    Route::post('/sentiment-tracking', [Admin\Marketing\Tool\ToolController::class, 'storeSentiment'])->name('sentiment-tracking.store');
    Route::get('/sentiment-tracking/{sentiment}/edit', [Admin\Marketing\Tool\ToolController::class, 'editSentiment'])->name('sentiment-tracking.edit');
    Route::put('/sentiment-tracking/{sentiment}', [Admin\Marketing\Tool\ToolController::class, 'updateSentiment'])->name('sentiment-tracking.update');
    Route::delete('/sentiment-tracking/{sentiment}', [Admin\Marketing\Tool\ToolController::class, 'destroySentiment'])->name('sentiment-tracking.destroy');
    Route::get('/live-chat', [Admin\Marketing\Tool\ToolController::class, 'liveChat'])->name('live-chat');
    Route::post('/live-chat/send', [Admin\Marketing\Tool\ToolController::class, 'sendMessage'])->name('live-chat.send');
    Route::get('/live-chat/messages/{userId}', [Admin\Marketing\Tool\ToolController::class, 'getMessages'])->name('live-chat.messages');
    
    Route::get('/lead-management', [Admin\Marketing\CRM\CRMController::class, 'leadManagement'])->name('lead-management');
    Route::get('/territory-mapping', [Admin\Marketing\CRM\CRMController::class, 'territoryMapping'])->name('territory-mapping');
    Route::get('/target-achievement', [Admin\Marketing\CRM\CRMController::class, 'targetAchievement'])->name('target-achievement');
    Route::get('/pipeline-tracker', [Admin\Marketing\CRM\CRMController::class, 'pipelineTracker'])->name('pipeline-tracker');
    Route::get('/merchant-ranking', [Admin\Marketing\CRM\CRMController::class, 'merchantRanking'])->name('merchant-ranking');
    
    Route::get('/contract-vault', [Admin\Marketing\Contract\ContractController::class, 'vault'])->name('contract-vault');
    Route::get('/expiry-alerts', [Admin\Marketing\Contract\ContractController::class, 'expiryAlerts'])->name('expiry-alerts');
    Route::get('/rate-change-requests', [Admin\Marketing\Contract\ContractController::class, 'rateChangeRequests'])->name('rate-change-requests');
});

// SUPPORT & COMPLAINTS - Extended Routes (Controllers need to be created)
Route::prefix('support')->name('support.')->group(function () {
    // Route::get('/tickets/new', [Admin\Support\TicketController::class, 'create'])->name('tickets.new');
    // Route::get('/tickets/in-progress', [Admin\Support\TicketController::class, 'inProgress'])->name('tickets.in-progress');
    // Route::get('/tickets/resolved', [Admin\Support\TicketController::class, 'resolved'])->name('tickets.resolved');
    // Route::get('/tickets/escalated', [Admin\Support\TicketController::class, 'escalated'])->name('tickets.escalated');
    // Route::post('/tickets', [Admin\Support\TicketController::class, 'store'])->name('tickets.store');
    // Route::put('/tickets/{ticket}/escalate', [Admin\Support\TicketController::class, 'escalate'])->name('tickets.escalate');
    
    // Route::get('/interaction-logs/calls', [Admin\Support\InteractionController::class, 'callLogs'])->name('interaction.calls');
    // Route::get('/interaction-logs/chats', [Admin\Support\InteractionController::class, 'chatLogs'])->name('interaction.chats');
    // Route::get('/interaction-logs/emails', [Admin\Support\Interaction\InteractionController::class, 'emailLogs'])->name('interaction.emails');
    
    Route::get('/knowledge-base/faqs', [Admin\Support\KnowledgeBase\KnowledgeBaseController::class, 'faqs'])->name('kb.faqs');
    Route::get('/knowledge-base/quick-replies', [Admin\Support\KnowledgeBase\KnowledgeBaseController::class, 'quickReplies'])->name('kb.quick-replies');
    Route::get('/knowledge-base/sop', [Admin\Support\KnowledgeBase\KnowledgeBaseController::class, 'sop'])->name('kb.sop');
    
    Route::get('/reports/daily', [Admin\Support\Report\ReportController::class, 'dailyTicket'])->name('reports.daily');
    Route::get('/reports/sla-breach', [Admin\Support\Report\ReportController::class, 'slaBreach'])->name('reports.sla-breach');
    Route::get('/reports/agent-performance', [Admin\Support\Report\ReportController::class, 'agentPerformance'])->name('reports.agent-performance');
});

// RIDER OPERATIONS - Extended Routes
Route::prefix('riders')->name('riders.')->group(function () {
    Route::get('/profiles', [Admin\Rider\Profile\ProfileController::class, 'index'])->name('profiles');
    Route::post('/profiles', [Admin\Rider\Profile\ProfileController::class, 'store'])->name('profiles.store');
    Route::get('/attendance', [Admin\Rider\Profile\ProfileController::class, 'attendance'])->name('attendance');
    Route::get('/gps-tracking', [Admin\Rider\Profile\ProfileController::class, 'gpsTracking'])->name('gps-tracking');
    
    Route::get('/assign-parcels', [Admin\Rider\Operation\OperationController::class, 'assignParcels'])->name('assign-parcels');
    Route::post('/assign-parcels', [Admin\Rider\Operation\OperationController::class, 'storeAssignment'])->name('assign-parcels.store');
    
    Route::get('/performance/efficiency', [Admin\Rider\Performance\PerformanceController::class, 'efficiency'])->name('performance.efficiency');
    Route::get('/performance/handover', [Admin\Rider\Performance\PerformanceController::class, 'handover'])->name('performance.handover');
    Route::get('/performance/top-riders', [Admin\Rider\Performance\PerformanceController::class, 'topRiders'])->name('performance.top-riders');
    
    Route::get('/finance/cash-collection', [Admin\Rider\Finance\FinanceController::class, 'cashCollection'])->name('finance.cash-collection');
    Route::get('/finance/pending-cod', [Admin\Rider\Finance\FinanceController::class, 'pendingCOD'])->name('finance.pending-cod');
    Route::get('/finance/discrepancy', [Admin\Rider\Finance\FinanceController::class, 'discrepancy'])->name('finance.discrepancy');
});

// BRANCH OPERATIONS - Extended Routes
Route::prefix('branch')->name('branch.')->group(function () {
    // Interactive bagging flow
    Route::get('/bagging', [Admin\Branch\Bagging\ManageBaggingController::class, 'index'])->name('bagging');
    Route::post('/bagging/open', [Admin\Branch\Bagging\ManageBaggingController::class, 'create'])->name('bagging.open');
    Route::post('/bagging/items', [Admin\Branch\Bagging\ManageBaggingController::class, 'addItem'])->name('bagging.items.add');
    Route::post('/bagging/{bag}/items/{item}/remove', [Admin\Branch\Bagging\ManageBaggingController::class, 'removeItem'])->name('bagging.items.remove');
    Route::post('/bagging/{bag}/seal', [Admin\Branch\Bagging\ManageBaggingController::class, 'seal'])->name('bagging.seal');
    Route::get('/bagging/{bag}/manifest', [Admin\Branch\Bagging\ManageBaggingController::class, 'manifest'])->name('bagging.manifest');
    
    Route::get('/pickup-orders', [Admin\Branch\Operation\OperationController::class, 'pickupOrders'])->name('pickup-orders');
    Route::get('/receive-shipments', [Admin\Branch\Operation\OperationController::class, 'receiveShipments'])->name('receive-shipments');
    Route::post('/receive-shipments', [Admin\Branch\Operation\OperationController::class, 'storeReceive'])->name('receive-shipments.store');
    Route::get('/dispatch-shipments', [Admin\Branch\Operation\OperationController::class, 'dispatchShipments'])->name('dispatch-shipments');
    Route::post('/dispatch-shipments', [Admin\Branch\Operation\OperationController::class, 'storeDispatch'])->name('dispatch-shipments.store');
    Route::get('/carrier-manifest', [Admin\Branch\Operation\OperationController::class, 'carrierManifest'])->name('carrier-manifest');
    Route::get('/deliveries-assigned', [Admin\Branch\Operation\OperationController::class, 'deliveriesAssigned'])->name('deliveries-assigned');
    Route::get('/successful-deliveries', [Admin\Branch\Operation\OperationController::class, 'successfulDeliveries'])->name('successful-deliveries');
    Route::get('/failed-deliveries', [Admin\Branch\Operation\OperationController::class, 'failedDeliveries'])->name('failed-deliveries');
    Route::get('/return-shipments', [Admin\Branch\Operation\OperationController::class, 'returnShipments'])->name('return-shipments');
    Route::get('/shipment-tracking', [Admin\Branch\Operation\OperationController::class, 'shipmentTracking'])->name('shipment-tracking');
    
    // Route::get('/staff/manage', [Admin\Branch\Staff\StaffController::class, 'manage'])->name('staff.manage');
    // Route::get('/staff/salary', [Admin\Branch\Staff\StaffController::class, 'salary'])->name('staff.salary');
    // Route::get('/staff/attendance', [Admin\Branch\Staff\StaffController::class, 'attendance'])->name('staff.attendance');
    
    Route::get('/cod/pending', [Admin\Branch\COD\CODController::class, 'pending'])->name('cod.pending');
    Route::get('/cod/variance', [Admin\Branch\COD\CODController::class, 'variance'])->name('cod.variance');
    Route::get('/cod/collect', [Admin\Branch\COD\CODController::class, 'collect'])->name('cod.collect');
    Route::post('/cod/deposit', [Admin\Branch\COD\CODController::class, 'markDeposited'])->name('cod.deposit');
    Route::get('/cod/in-transit', [Admin\Branch\COD\CODController::class, 'inTransit'])->name('cod.in-transit');
});

// HR & EMPLOYEES - Extended Routes
Route::prefix('hr')->name('hr.')->group(function () {
    Route::get('/recruitment', [Admin\HR\RecruitmentController::class, 'index'])->name('recruitment');
    Route::post('/recruitment', [Admin\HR\RecruitmentController::class, 'store'])->name('recruitment.store');
    
    Route::get('/attendance', [Admin\HR\AttendanceController::class, 'index'])->name('attendance');
    Route::post('/attendance', [Admin\HR\AttendanceController::class, 'mark'])->name('attendance.mark');
    Route::get('/leaves', [Admin\HR\AttendanceController::class, 'leaves'])->name('leaves');
    Route::post('/leaves', [Admin\HR\AttendanceController::class, 'applyLeave'])->name('leaves.apply');
    
    Route::get('/exit-handover', [Admin\HR\ExitController::class, 'index'])->name('exit-handover');
    Route::post('/exit-handover', [Admin\HR\ExitController::class, 'process'])->name('exit-handover.process');
    
    Route::get('/performance-kpis', [Admin\HR\PerformanceController::class, 'kpis'])->name('performance-kpis');
    Route::post('/performance-kpis', [Admin\HR\PerformanceController::class, 'storeReview'])->name('performance-kpis.store');
    
    Route::get('/training', [Admin\HR\TrainingController::class, 'index'])->name('training');
    Route::get('/documents', [Admin\HR\TrainingController::class, 'documents'])->name('documents');
});

// LOGISTICS & OPS
Route::prefix('logistics')->name('logistics.')->group(function () {
    Route::get('/bagging-manifest', [Admin\Logistics\Manifest\ManifestController::class, 'index'])->name('bagging-manifest');
    Route::get('/vehicle-dispatch', [Admin\Logistics\Vehicle\VehicleController::class, 'dispatch'])->name('vehicle-dispatch');
    // Route::get('/shortage-reports', [Admin\Logistics\ReportController::class, 'shortage'])->name('shortage-reports');
    Route::get('/routing-efficiency', [Admin\Logistics\Route\RouteController::class, 'efficiency'])->name('routing-efficiency');
});

// COMPLIANCE & AUDIT
Route::prefix('compliance')->name('compliance.')->group(function () {
    Route::get('/audit-logs', [Admin\Compliance\Audit\AuditController::class, 'logs'])->name('audit-logs');
    Route::get('/fraud-detection', [Admin\Compliance\Fraud\FraudController::class, 'index'])->name('fraud-detection');
    Route::get('/tax-compliance', [Admin\Compliance\Tax\TaxController::class, 'status'])->name('tax-compliance');
    Route::get('/branch-errors', [Admin\Compliance\Error\ErrorController::class, 'branchErrors'])->name('branch-errors');
});

// SYSTEM SETTINGS - Extended Routes
Route::prefix('settings')->name('settings.')->group(function () {
    Route::get('/module-integrations', [Admin\Settings\Integration\IntegrationController::class, 'index'])->name('module-integrations');
    Route::post('/module-integrations', [Admin\Settings\Integration\IntegrationController::class, 'configure'])->name('module-integrations.configure');
    Route::get('/api-access', [Admin\Settings\API\APIController::class, 'index'])->name('api-access');
    Route::post('/api-access/generate', [Admin\Settings\API\APIController::class, 'generateKey'])->name('api-access.generate');
    Route::get('/internal-updates', [Admin\Settings\Update\UpdateController::class, 'index'])->name('internal-updates');
});
