
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, User } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { History, User as UserIcon, Truck, Archive, CircleDollarSign } from 'lucide-react';
import { Avatar, AvatarImage, AvatarFallback } from '@/components/ui/avatar';
import { mockRiders } from '@/lib/data';
import { formatDistanceToNow } from 'date-fns';

const mockStaff: User[] = [
    { id: 'staff-1', name: 'Ahmed Hassan', email: 'ahmed.h@branch.com', role: 'branch-operator', companyName: 'Multan Branch', avatar: 'https://picsum.photos/seed/staff1/100/100' },
    { id: 'staff-2', name: 'Aisha Bibi', email: 'aisha.b@branch.com', role: 'branch-operator', companyName: 'Multan Branch', avatar: 'https://picsum.photos/seed/staff2/100/100' },
];

type Activity = {
  id: string;
  actor: {
    name: string;
    avatar: string;
  };
  action: string;
  target?: string;
  timestamp: Date;
  icon: React.ElementType;
};

const activities: Activity[] = [
  {
    id: 'act-1',
    actor: { name: mockRiders[0].name, avatar: mockRiders[0].avatar },
    action: 'marked shipment as Delivered',
    target: 'PCL162818',
    timestamp: new Date(Date.now() - 5 * 60 * 1000),
    icon: Truck,
  },
  {
    id: 'act-2',
    actor: { name: mockStaff[0].name, avatar: mockStaff[0].avatar },
    action: 'created dispatch bag',
    target: 'BAG-123456',
    timestamp: new Date(Date.now() - 15 * 60 * 1000),
    icon: Archive,
  },
    {
    id: 'act-3',
    actor: { name: mockStaff[1].name, avatar: mockStaff[1].avatar },
    action: 'reconciled COD from',
    target: mockRiders[1].name,
    timestamp: new Date(Date.now() - 45 * 60 * 1000),
    icon: CircleDollarSign,
  },
  {
    id: 'act-4',
    actor: { name: mockStaff[0].name, avatar: mockStaff[0].avatar },
    action: 'unbagged incoming shipment',
    target: 'BAG-789012',
    timestamp: new Date(Date.now() - 2 * 60 * 60 * 1000),
    icon: Archive,
  },
   {
    id: 'act-5',
    actor: { name: mockRiders[2].name, avatar: mockRiders[2].avatar },
    action: 'marked delivery as Failed for',
    target: 'PCL162822',
    timestamp: new Date(Date.now() - 3 * 60 * 60 * 1000),
    icon: Truck,
  },
];


export default function AdminBranchActivityPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Activity Log</CardTitle>
              <CardDescription>
                A real-time feed of the latest activities from your branch staff and riders.
              </CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-6">
                {activities.map((activity) => (
                   <div key={activity.id} className="flex items-start gap-4">
                        <Avatar className="h-10 w-10 border">
                            <AvatarImage src={activity.actor.avatar} />
                            <AvatarFallback>{activity.actor.name.charAt(0)}</AvatarFallback>
                        </Avatar>
                        <div className="flex-1">
                            <p className="text-sm">
                                <span className="font-semibold">{activity.actor.name}</span>
                                {' '}
                                {activity.action}
                                {' '}
                                {activity.target && <span className="font-medium text-primary">{activity.target}</span>}
                            </p>
                            <p className="text-xs text-muted-foreground">
                                {formatDistanceToNow(activity.timestamp, { addSuffix: true })}
                            </p>
                        </div>
                        <div className="flex h-8 w-8 items-center justify-center rounded-full bg-muted">
                            <activity.icon className="h-4 w-4 text-muted-foreground" />
                        </div>
                   </div>
                ))}
              </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
