
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Rider } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { mockRiders } from '@/lib/data';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Avatar, AvatarImage, AvatarFallback } from '@/components/ui/avatar';
import { Button } from '@/components/ui/button';

type AssignedCodInfo = {
    rider: Rider;
    shipmentCount: number;
    totalCod: number;
}

const assignedCodData: AssignedCodInfo[] = [
    { rider: mockRiders[0], shipmentCount: 15, totalCod: 25500 },
    { rider: mockRiders[1], shipmentCount: 12, totalCod: 18300 },
    { rider: mockRiders[2], shipmentCount: 18, totalCod: 32400 },
];


export default function AdminBranchCodValueAssignedPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>COD Value Assigned</CardTitle>
              <CardDescription>
                View the total COD value assigned to each rider for the current day.
              </CardDescription>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Rider</TableHead>
                        <TableHead>Total Shipments Assigned</TableHead>
                        <TableHead>Total COD Value (PKR)</TableHead>
                        <TableHead className="text-right">Action</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {assignedCodData.map(item => (
                        <TableRow key={item.rider.id}>
                            <TableCell>
                                <div className="flex items-center gap-3">
                                    <Avatar>
                                        <AvatarImage src={item.rider.avatar} />
                                        <AvatarFallback>{item.rider.name.charAt(0)}</AvatarFallback>
                                    </Avatar>
                                    <div>
                                        <p className="font-medium">{item.rider.name}</p>
                                        <p className="text-sm text-muted-foreground">Zone: {item.rider.zone}</p>
                                    </div>
                                </div>
                            </TableCell>
                            <TableCell>{item.shipmentCount}</TableCell>
                            <TableCell className="font-medium">{item.totalCod.toLocaleString()}</TableCell>
                            <TableCell className="text-right">
                                <Button size="sm" variant="outline">
                                    View Details
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
