
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { 
    Truck, 
    CheckCircle, 
    XCircle, 
    RefreshCcw, 
    Banknote, 
    ArrowRightLeft, 
    Download, 
    Archive,
    ArchiveRestore,
    ClipboardList,
    Hourglass,
    MessageSquareWarning,
    Bell,
    History,
    FileClock,
    UserRoundCheck
} from 'lucide-react';

const kpiCards = [
    { title: 'Assigned Shipments', value: '120', icon: UserRoundCheck, description: 'Shipments assigned to riders today' },
    { title: 'Delivered', value: '85', icon: CheckCircle, description: 'Successfully delivered shipments' },
    { title: 'Failed', value: '10', icon: XCircle, description: 'Failed delivery attempts' },
    { title: 'Return (RTO)', value: '5', icon: RefreshCcw, description: 'Shipments marked for return' },
    { title: 'COD Collected vs Deposited', value: '150K / 145K', icon: Banknote, description: 'PKR Collected / Deposited' },
    { title: 'Move to Origin', value: '15', icon: ArrowRightLeft, description: 'Parcels to be moved to origin hub' },
    { title: 'Received', value: '250', icon: Download, description: 'Parcels received at the branch' },
    { title: 'Bags Received', value: '12', icon: Archive, description: 'Incoming bags' },
    { title: 'Un-Bagging', value: '8', icon: ArchiveRestore, description: 'Bags to be un-scanned' },
    { title: 'Pickup Orders', value: '25', icon: ClipboardList, description: 'Pending pickup assignments' },
    { title: 'Pending Orders', value: '45', icon: Hourglass, description: 'Orders waiting for assignment' },
    { title: 'Reattempt Pending', value: '8', icon: History, description: 'Shipments pending reattempt' },
    { title: 'Amount Pending to Deposit', value: 'PKR 5,000', icon: FileClock, description: 'COD variance' },
    { title: 'Complaints', value: '3', icon: MessageSquareWarning, description: 'Active branch complaints' },
    { title: 'Internal Updates', value: '2', icon: Bell, description: 'New notifications for branch' },
];


export default function AdminBranchDashboardPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Branch Dashboard</CardTitle>
              <CardDescription>
                Overview of all operations for your branch today.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4">
                    {kpiCards.map(card => (
                         <Card key={card.title}>
                            <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                                <CardTitle className="text-sm font-medium">{card.title}</CardTitle>
                                <card.icon className="h-4 w-4 text-muted-foreground" />
                            </CardHeader>
                            <CardContent>
                                <div className="text-2xl font-bold">{card.value}</div>
                                <p className="text-xs text-muted-foreground">{card.description}</p>
                            </CardContent>
                        </Card>
                    ))}
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
