
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { mockParcels } from '@/lib/data';
import { Badge } from '@/components/ui/badge';
import { format } from 'date-fns';
import { Button } from '@/components/ui/button';

export default function AdminBranchDeliveryFailedPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  const failedDeliveries: Parcel[] = mockParcels.filter(p => p.status === 'Failed' || p.status === 'Returned');

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Failed & Returned Deliveries</CardTitle>
              <CardDescription>
                Parcels that could not be delivered.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <Table>
                    <TableHeader>
                        <TableRow>
                            <TableHead>Parcel ID</TableHead>
                            <TableHead>Customer</TableHead>
                            <TableHead>Reason</TableHead>
                            <TableHead>Date</TableHead>
                            <TableHead>Status</TableHead>
                            <TableHead>Action</TableHead>
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                        {failedDeliveries.map(order => (
                            <TableRow key={order.id}>
                                <TableCell>{order.id}</TableCell>
                                <TableCell>{order.recipientName}</TableCell>
                                <TableCell>Customer refused delivery</TableCell>
                                <TableCell>{format(new Date(order.bookingDate), 'dd MMM, yyyy')}</TableCell>
                                <TableCell>
                                    <Badge variant="destructive">{order.status}</Badge>
                                </TableCell>
                                <TableCell>
                                    <Button variant="outline" size="sm">Process Return</Button>
                                </TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
