
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { mockParcels } from '@/lib/data';
import { Badge } from '@/components/ui/badge';
import { format } from 'date-fns';

export default function AdminBranchDeliverySuccessPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  const successfulDeliveries: Parcel[] = mockParcels.filter(p => p.status === 'Delivered');

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Successful Deliveries</CardTitle>
              <CardDescription>
                A list of all parcels successfully delivered today.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <Table>
                    <TableHeader>
                        <TableRow>
                            <TableHead>Parcel ID</TableHead>
                            <TableHead>Customer</TableHead>
                            <TableHead>Address</TableHead>
                            <TableHead>Delivered On</TableHead>
                            <TableHead>COD Amount</TableHead>
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                        {successfulDeliveries.map(order => (
                            <TableRow key={order.id}>
                                <TableCell>{order.id}</TableCell>
                                <TableCell>{order.recipientName}</TableCell>
                                <TableCell className="max-w-xs truncate">{order.address}</TableCell>
                                <TableCell>{format(new Date(order.bookingDate), 'dd MMM, yyyy')}</TableCell>
                                <TableCell>PKR {order.codAmount.toFixed(2)}</TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
