
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Rider } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { mockRiders } from '@/lib/data';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Avatar, AvatarImage, AvatarFallback } from '@/components/ui/avatar';
import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';
import { HandCoins } from 'lucide-react';

type PendingCodInfo = {
    rider: Rider;
    shipmentCount: number;
    totalCod: number;
    status: 'Pending' | 'Verified';
}

const pendingCodData: PendingCodInfo[] = [
    { rider: mockRiders[0], shipmentCount: 5, totalCod: 8500, status: 'Pending' },
    { rider: mockRiders[1], shipmentCount: 7, totalCod: 12300, status: 'Pending' },
    { rider: mockRiders[2], shipmentCount: 4, totalCod: 6400, status: 'Verified' },
];


export default function AdminBranchFinancePendingCodPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Pending COD from Riders</CardTitle>
              <CardDescription>
                Review and confirm COD amounts handed over by riders at the end of their shifts.
              </CardDescription>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Rider</TableHead>
                        <TableHead>Shipments Delivered</TableHead>
                        <TableHead>Total COD Amount</TableHead>
                        <TableHead>Status</TableHead>
                        <TableHead className="text-right">Action</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {pendingCodData.map(item => (
                        <TableRow key={item.rider.id}>
                            <TableCell>
                                <div className="flex items-center gap-3">
                                    <Avatar>
                                        <AvatarImage src={item.rider.avatar} />
                                        <AvatarFallback>{item.rider.name.charAt(0)}</AvatarFallback>
                                    </Avatar>
                                    <div>
                                        <p className="font-medium">{item.rider.name}</p>
                                        <p className="text-sm text-muted-foreground">Zone: {item.rider.zone}</p>
                                    </div>
                                </div>
                            </TableCell>
                            <TableCell>{item.shipmentCount}</TableCell>
                            <TableCell>PKR {item.totalCod.toFixed(2)}</TableCell>
                            <TableCell>
                                <Badge variant={item.status === 'Pending' ? 'destructive' : 'secondary'}>{item.status}</Badge>
                            </TableCell>
                            <TableCell className="text-right">
                                <Button size="sm" disabled={item.status === 'Verified'}>
                                    <HandCoins className="mr-2 h-4 w-4" />
                                    Confirm Handover
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
