

'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Badge } from '@/components/ui/badge';
import { Checkbox } from '@/components/ui/checkbox';
import { useState } from 'react';
import { mockParcels } from '@/lib/data';
import { Truck } from 'lucide-react';

export default function AdminBranchForwardToOriginPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  const returnedParcels = mockParcels.filter(p => p.status === 'Returned').slice(0, 3);
  const [selectedParcels, setSelectedParcels] = useState<string[]>([]);

  const handleSelectAll = (checked: boolean) => {
    setSelectedParcels(checked ? returnedParcels.map(p => p.id) : []);
  };

  const handleSelectRow = (parcelId: string, checked: boolean) => {
    if (checked) {
      setSelectedParcels(prev => [...prev, parcelId]);
    } else {
      setSelectedParcels(prev => prev.filter(id => id !== parcelId));
    }
  };

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Forward to Origin / Hub</CardTitle>
              <CardDescription>
                Select returned shipments to process and forward to the origin hub.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <Table>
                    <TableHeader>
                        <TableRow>
                            <TableHead>
                                <Checkbox onCheckedChange={(c) => handleSelectAll(c as boolean)} />
                            </TableHead>
                            <TableHead>Parcel ID</TableHead>
                            <TableHead>Return Reason</TableHead>
                            <TableHead>Customer</TableHead>
                            <TableHead>Status</TableHead>
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                        {returnedParcels.map(parcel => (
                            <TableRow key={parcel.id}>
                                <TableCell>
                                    <Checkbox 
                                        checked={selectedParcels.includes(parcel.id)}
                                        onCheckedChange={(c) => handleSelectRow(parcel.id, c as boolean)}
                                    />
                                </TableCell>
                                <TableCell>{parcel.id}</TableCell>
                                <TableCell>Customer refused</TableCell>
                                <TableCell>{parcel.recipientName}</TableCell>
                                <TableCell>
                                    <Badge variant="destructive">{parcel.status}</Badge>
                                </TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </CardContent>
            <CardFooter>
                <Button disabled={selectedParcels.length === 0}>
                    <Truck className="mr-2 h-4 w-4" />
                    Forward Selected ({selectedParcels.length})
                </Button>
            </CardFooter>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
