
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { AlertCircle, Clock } from 'lucide-react';
import { mockParcels } from '@/lib/data';
import { Button } from '@/components/ui/button';
import { Badge } from '@/components/ui/badge';
import { formatDistanceToNow } from 'date-fns';

export default function AdminBranchLostHoldPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  const onHoldParcels = mockParcels.filter(p => p.status === 'Pending').slice(0, 2).map(p => ({...p, holdReason: 'Awaiting customer response'}));
  const lostParcels = mockParcels.filter(p => p.status === 'Failed').slice(0,1).map(p => ({...p, status: 'Lost'}));

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
            <Card>
                <CardHeader>
                    <CardTitle>On-Hold Shipments</CardTitle>
                    <CardDescription>
                    Shipments that are currently on hold, awaiting action.
                    </CardDescription>
                </CardHeader>
                <CardContent className="grid gap-4 md:grid-cols-2">
                    {onHoldParcels.map(parcel => (
                        <Card key={parcel.id}>
                            <CardHeader>
                                <CardTitle className="text-base flex items-center justify-between">
                                    {parcel.id}
                                    <Badge variant="secondary">{parcel.status}</Badge>
                                </CardTitle>
                                <CardDescription>{parcel.recipientName}</CardDescription>
                            </CardHeader>
                            <CardContent>
                                <p className="text-sm font-medium">{parcel.holdReason}</p>
                                <p className="text-xs text-muted-foreground flex items-center gap-1 mt-2">
                                    <Clock className="h-3 w-3" />
                                    On hold for {formatDistanceToNow(new Date(parcel.bookingDate))}
                                </p>
                            </CardContent>
                            <CardFooter>
                                <Button>Resolve</Button>
                            </CardFooter>
                        </Card>
                    ))}
                </CardContent>
            </Card>

             <Card>
                <CardHeader>
                    <CardTitle>Lost &amp; Escalated Shipments</CardTitle>
                    <CardDescription>
                    Shipments that have been marked as lost and escalated for investigation.
                    </CardDescription>
                </CardHeader>
                <CardContent className="grid gap-4 md:grid-cols-2">
                    {lostParcels.map(parcel => (
                        <Card key={parcel.id} className="border-destructive">
                            <CardHeader>
                                <CardTitle className="text-base flex items-center justify-between">
                                    {parcel.id}
                                    <Badge variant="destructive">{parcel.status}</Badge>
                                </CardTitle>
                                <CardDescription>{parcel.recipientName}</CardDescription>
                            </CardHeader>
                            <CardContent>
                                <p className="text-sm font-medium flex items-center gap-2 text-destructive">
                                    <AlertCircle className="h-4 w-4" />
                                    Automatically escalated due to SLA breach.
                                </p>
                                <p className="text-xs text-muted-foreground mt-2">
                                   Last seen {formatDistanceToNow(new Date(parcel.bookingDate))} ago.
                                </p>
                            </CardContent>
                             <CardFooter>
                                <Button variant="destructive">View Investigation</Button>
                            </CardFooter>
                        </Card>
                    ))}
                </CardContent>
            </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
