

'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel, Rider } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { mockParcels, mockRiders } from '@/lib/data';
import { Badge } from '@/components/ui/badge';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { Button } from '@/components/ui/button';
import { MoreVertical } from 'lucide-react';

type PickupOrder = {
    parcel: Parcel;
    rider: Rider;
};

export default function AdminBranchPickupPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  const pickupOrders: PickupOrder[] = mockParcels.slice(0, 3).map((p, i) => ({
      parcel: { ...p, status: 'Picked Up'},
      rider: mockRiders[i % mockRiders.length]
  }));

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Pickup Orders</CardTitle>
              <CardDescription>
                Parcels assigned to riders for pickup.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <Table>
                    <TableHeader>
                        <TableRow>
                            <TableHead>Rider</TableHead>
                            <TableHead>Parcel ID</TableHead>
                            <TableHead>Customer</TableHead>
                            <TableHead>Address</TableHead>
                            <TableHead>Status</TableHead>
                            <TableHead>Actions</TableHead>
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                        {pickupOrders.map(order => (
                            <TableRow key={order.parcel.id}>
                                <TableCell>
                                    <div className="flex items-center gap-3">
                                        <Avatar>
                                            <AvatarImage src={order.rider.avatar} />
                                            <AvatarFallback>{order.rider.name.charAt(0)}</AvatarFallback>
                                        </Avatar>
                                        <div>
                                            <p className="font-medium">{order.rider.name}</p>
                                            <p className="text-sm text-muted-foreground">Zone: {order.rider.zone}</p>
                                        </div>
                                    </div>
                                </TableCell>
                                <TableCell>{order.parcel.id}</TableCell>
                                <TableCell>{order.parcel.recipientName}</TableCell>
                                <TableCell className="max-w-xs truncate">{order.parcel.address}</TableCell>
                                <TableCell>
                                    <Badge variant="secondary">{order.parcel.status}</Badge>
                                </TableCell>
                                <TableCell>
                                    <Button variant="ghost" size="icon">
                                        <MoreVertical className="h-4 w-4" />
                                    </Button>
                                </TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
