
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Rider } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { mockRiders } from '@/lib/data';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Avatar, AvatarImage, AvatarFallback } from '@/components/ui/avatar';
import { Button } from '@/components/ui/button';
import { Badge } from '@/components/ui/badge';

type RiderLoadInfo = {
    rider: Rider;
    totalShipments: number;
    delivered: number;
    failed: number;
    pending: number;
    totalCod: number;
}

const riderLoadData: RiderLoadInfo[] = [
    { rider: mockRiders[0], totalShipments: 15, delivered: 10, failed: 2, pending: 3, totalCod: 25500 },
    { rider: mockRiders[1], totalShipments: 12, delivered: 8, failed: 1, pending: 3, totalCod: 18300 },
    { rider: mockRiders[2], totalShipments: 18, delivered: 12, failed: 3, pending: 3, totalCod: 32400 },
];


export default function AdminBranchRiderDailyLoadPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Rider Daily Load</CardTitle>
              <CardDescription>
                Auto-generated daily load summary for each rider at the start of the day.
              </CardDescription>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Rider</TableHead>
                        <TableHead>Total Shipments</TableHead>
                        <TableHead>Delivered</TableHead>
                        <TableHead>Failed</TableHead>
                        <TableHead>Pending</TableHead>
                        <TableHead>Total COD Value (PKR)</TableHead>
                        <TableHead className="text-right">Action</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {riderLoadData.map(item => (
                        <TableRow key={item.rider.id}>
                            <TableCell>
                                <div className="flex items-center gap-3">
                                    <Avatar>
                                        <AvatarImage src={item.rider.avatar} />
                                        <AvatarFallback>{item.rider.name.charAt(0)}</AvatarFallback>
                                    </Avatar>
                                    <div>
                                        <p className="font-medium">{item.rider.name}</p>
                                        <p className="text-sm text-muted-foreground">Zone: {item.rider.zone}</p>
                                    </div>
                                </div>
                            </TableCell>
                            <TableCell>{item.totalShipments}</TableCell>
                            <TableCell>
                                <Badge variant="secondary" className="bg-green-100 text-green-800">{item.delivered}</Badge>
                            </TableCell>
                             <TableCell>
                                <Badge variant="destructive">{item.failed}</Badge>
                            </TableCell>
                             <TableCell>
                                <Badge variant="outline">{item.pending}</Badge>
                            </TableCell>
                            <TableCell className="font-medium">{item.totalCod.toLocaleString()}</TableCell>
                            <TableCell className="text-right">
                                <Button size="sm" variant="outline">
                                    View Loadsheet
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
