
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Input } from '@/components/ui/input';
import { Button } from '@/components/ui/button';
import { ScanLine, Search } from 'lucide-react';
import { mockParcels } from '@/lib/data';
import { Badge } from '@/components/ui/badge';
import { useToast } from '@/hooks/use-toast';

export default function AdminBranchScanningPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};
  const [parcelId, setParcelId] = useState('');
  const [scannedParcel, setScannedParcel] = useState<Parcel | null>(null);
  const { toast } = useToast();

  const handleScan = () => {
    if (!parcelId) return;
    const parcel = mockParcels.find(p => p.id.toLowerCase() === parcelId.toLowerCase());
    if (parcel) {
        setScannedParcel(parcel);
        toast({
            title: 'Scan Successful',
            description: `Parcel ${parcel.id} found. Ready to be added to bag.`,
        });
    } else {
        setScannedParcel(null);
        toast({
            variant: 'destructive',
            title: 'Scan Failed',
            description: 'No parcel found with this ID.',
        });
    }
  };

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Receive Shipments</CardTitle>
              <CardDescription>
                Scan received packets to add them to your branch inventory.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <div className="flex items-center gap-2 max-w-lg mx-auto">
                    <div className="relative flex-1">
                        <ScanLine className="absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground" />
                        <Input 
                            placeholder="Scan or enter parcel ID..." 
                            className="pl-10 h-12 text-lg" 
                            value={parcelId}
                            onChange={(e) => setParcelId(e.target.value)}
                            onKeyDown={(e) => e.key === 'Enter' && handleScan()}
                        />
                    </div>
                    <Button size="lg" className="h-12" onClick={handleScan}>
                        <Search className="mr-2 h-5 w-5" /> Find
                    </Button>
                </div>
            </CardContent>
          </Card>

          {scannedParcel && (
            <Card className="animate-in fade-in-50">
                <CardHeader>
                    <CardTitle className="flex items-center justify-between">
                        Parcel Details
                        <Badge variant="outline" className="text-base">{scannedParcel.status}</Badge>
                    </CardTitle>
                    <CardDescription>ID: {scannedParcel.id}</CardDescription>
                </CardHeader>
                <CardContent className="grid md:grid-cols-2 gap-4">
                    <div><span className="font-semibold">Recipient:</span> {scannedParcel.recipientName}</div>
                    <div><span className="font-semibold">City:</span> {scannedParcel.city}</div>
                    <div className="md:col-span-2"><span className="font-semibold">Address:</span> {scannedParcel.address}</div>
                    <div><span className="font-semibold">COD Amount:</span> PKR {scannedParcel.codAmount.toFixed(2)}</div>
                </CardContent>
                <CardFooter>
                    <Button>Add to Bag</Button>
                </CardFooter>
            </Card>
          )}
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
