
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, User, UserRole } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';
import { MoreVertical, UserPlus } from 'lucide-react';
import { DropdownMenu, DropdownMenuTrigger, DropdownMenuContent, DropdownMenuItem } from '@/components/ui/dropdown-menu';

const mockStaff: User[] = [
    { id: 'staff-1', name: 'Ahmed Hassan', email: 'ahmed.h@branch.com', role: 'branch-operator', companyName: 'Multan Branch', avatar: 'https://picsum.photos/seed/staff1/100/100' },
    { id: 'staff-2', name: 'Aisha Bibi', email: 'aisha.b@branch.com', role: 'branch-operator', companyName: 'Multan Branch', avatar: 'https://picsum.photos/seed/staff2/100/100' },
    { id: 'staff-3', name: 'Bilal Khan', email: 'bilal.k@branch.com', role: 'branch-operator', companyName: 'Multan Branch', avatar: 'https://picsum.photos/seed/staff3/100/100' },
];

const roleColors: Record<UserRole, string> = {
    'super-admin': 'bg-red-500 text-white',
    'admin': 'bg-red-400 text-white',
    'finance': 'bg-green-500 text-white',
    'finance-manager': 'bg-green-600 text-white',
    'branch-operator': 'bg-blue-500 text-white',
    'marketing': 'bg-purple-500 text-white',
    'marketing-manager': 'bg-purple-600 text-white',
    'support': 'bg-yellow-500 text-white',
    'rider-manager': 'bg-orange-500 text-white',
    'seller': 'bg-gray-500 text-white'
};

export default function AdminBranchStaffManagementPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader className="flex flex-row items-center">
              <div className="grid gap-2">
                <CardTitle>Staff Management</CardTitle>
                <CardDescription>
                  Onboard, edit, and manage branch staff members.
                </CardDescription>
              </div>
              <Button size="sm" className="ml-auto gap-1">
                  <UserPlus className="h-4 w-4" />
                  Add Staff
              </Button>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>User</TableHead>
                        <TableHead>Role</TableHead>
                        <TableHead className="text-right">Actions</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {mockStaff.map(user => (
                        <TableRow key={user.id}>
                            <TableCell>
                                <div className="flex items-center gap-3">
                                    <Avatar>
                                        <AvatarImage src={user.avatar} alt={user.name} />
                                        <AvatarFallback>{user.name.charAt(0)}</AvatarFallback>
                                    </Avatar>
                                    <div>
                                        <p className="font-medium">{user.name}</p>
                                        <p className="text-sm text-muted-foreground">{user.email}</p>
                                    </div>
                                </div>
                            </TableCell>
                            <TableCell>
                                <Badge className={roleColors[user.role]}>Branch Operator</Badge>
                            </TableCell>
                            <TableCell className="text-right">
                                <DropdownMenu>
                                    <DropdownMenuTrigger asChild>
                                        <Button size="icon" variant="ghost">
                                            <MoreVertical className="h-4 w-4" />
                                        </Button>
                                    </DropdownMenuTrigger>
                                    <DropdownMenuContent>
                                        <DropdownMenuItem>Edit Profile</DropdownMenuItem>
                                        <DropdownMenuItem>Change Role</DropdownMenuItem>
                                        <DropdownMenuItem className="text-red-500">Delete User</DropdownMenuItem>
                                    </DropdownMenuContent>
                                </DropdownMenu>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
