
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, User } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Select, SelectTrigger, SelectValue, SelectContent, SelectItem } from '@/components/ui/select';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { useToast } from '@/hooks/use-toast';
import { Save } from 'lucide-react';

const mockStaff: Partial<User>[] = [
    { id: 'staff-1', name: 'Ahmed Hassan' },
    { id: 'staff-2', name: 'Aisha Bibi' },
    { id: 'staff-3', name: 'Bilal Khan' },
];

export default function AdminBranchStaffSalaryPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};
  const [selectedStaff, setSelectedStaff] = useState('');
  const { toast } = useToast();

  const handleSave = () => {
    if (!selectedStaff) {
        toast({
            variant: "destructive",
            title: "No Staff Selected",
            description: "Please select a staff member to configure their salary.",
        });
        return;
    }
    toast({
        title: "Salary Saved",
        description: `Salary configuration for the selected staff member has been updated.`,
    });
  }

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Staff Salary Configuration</CardTitle>
              <CardDescription>
                Set up and manage salary, allowances, and other compensation for branch staff.
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-6">
                <div className="max-w-2xl mx-auto space-y-4">
                    <div>
                        <Label htmlFor="staff-select">Select Staff Member</Label>
                        <Select value={selectedStaff} onValueChange={setSelectedStaff}>
                            <SelectTrigger id="staff-select">
                                <SelectValue placeholder="Select a staff member..." />
                            </SelectTrigger>
                            <SelectContent>
                                {mockStaff.map(staff => (
                                    <SelectItem key={staff.id} value={staff.id!}>
                                        {staff.name}
                                    </SelectItem>
                                ))}
                            </SelectContent>
                        </Select>
                    </div>

                    {selectedStaff && (
                        <div className="border rounded-lg p-4 space-y-4 animate-in fade-in-50">
                             <div>
                                <Label htmlFor="basic-salary">Basic Salary (PKR)</Label>
                                <Input id="basic-salary" type="number" placeholder="e.g., 30000" />
                            </div>
                             <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <Label htmlFor="fuel-allowance">Fuel Allowance (PKR)</Label>
                                    <Input id="fuel-allowance" type="number" placeholder="e.g., 2000" />
                                </div>
                                <div>
                                    <Label htmlFor="mobile-allowance">Mobile Allowance (PKR)</Label>
                                    <Input id="mobile-allowance" type="number" placeholder="e.g., 500" />
                                </div>
                            </div>
                            <div>
                                <Label htmlFor="other-deductions">Other Deductions (PKR)</Label>
                                <Input id="other-deductions" type="number" placeholder="e.g., 500" />
                            </div>
                        </div>
                    )}
                </div>
            </CardContent>
            <CardFooter className="border-t pt-6">
                 <Button onClick={handleSave} disabled={!selectedStaff}>
                    <Save className="mr-2 h-4 w-4" />
                    Save Configuration
                </Button>
            </CardFooter>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
